/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.informix.Lsn;
import io.debezium.relational.TableId;

public class InformixChangeTable {
    private static final String CDC_SCHEMA = "syscdcsv1";
    private final Lsn startLsn;
    private Lsn stopLsn;
    private final String captureInstance;
    private int changeTableObjectId;
    private TableId sourceTableId;
    private TableId changeTableId;

    public InformixChangeTable(TableId sourceTableId, String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this.sourceTableId = sourceTableId;
        this.changeTableObjectId = changeTableObjectId;
        this.startLsn = startLsn;
        this.stopLsn = stopLsn;
        this.captureInstance = captureInstance;
        this.changeTableId = sourceTableId != null ? new TableId(sourceTableId.catalog(), CDC_SCHEMA, captureInstance) : null;
    }

    public InformixChangeTable(String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this(null, captureInstance, changeTableObjectId, startLsn, stopLsn);
    }

    public String getCaptureInstance() {
        return this.captureInstance;
    }

    public Lsn getStartLsn() {
        return this.startLsn;
    }

    public Lsn getStopLsn() {
        return this.stopLsn;
    }

    public void setStopLsn(Lsn stopLsn) {
        this.stopLsn = stopLsn;
    }

    public TableId getSourceTableId() {
        return this.sourceTableId;
    }

    public TableId getChangeTableId() {
        return this.changeTableId;
    }

    public int getChangeTableObjectId() {
        return this.changeTableObjectId;
    }

    public String toString() {
        return "Capture instance \"" + this.getCaptureInstance() + "\" [sourceTableId=" + this.getSourceTableId() + ", changeTableId=" + this.getChangeTableId() + ", startLsn=" + this.startLsn + ", changeTableObjectId=" + this.getChangeTableObjectId() + ", stopLsn=" + this.stopLsn + "]";
    }
}

