/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.InformixConnectorTask;
import io.debezium.connector.informix.Module;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InformixConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixConnector.class);
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Map.copyOf(props);
    }

    public Class<? extends Task> taskClass() {
        return InformixConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return InformixConnectorConfig.configDef();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        InformixConnectorConfig connectorConfig = new InformixConnectorConfig(config);
        try (InformixConnection connection = new InformixConnection(connectorConfig.getJdbcConfig());){
            try {
                connection.connect();
                connection.execute(new String[]{"SELECT 1 FROM informix.systables"});
                LOGGER.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
            }
            catch (SQLException e) {
                LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{connection.connectionString(), connection.username(), e});
                hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(InformixConnectorConfig.ALL_FIELDS);
    }
}

