/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TransactionMetadataIT
extends AbstractConnectorTest {
    private InformixConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int not null, cola varchar(30), primary key (id))", "CREATE TABLE tableb (id int not null, colb varchar(30), primary key (id))", "INSERT INTO tablea VALUES(1, 'a')"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        TransactionMetadataIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{"DROP TABLE tablea", "DROP TABLE tableb"}).close();
        }
    }

    @Test
    public void transactionMetadata() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.INITIAL)).with(InformixConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        TransactionMetadataIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecordsByTopic(1);
        this.connection.setAutoCommit(false);
        for (int i = 10; i < 15; ++i) {
            this.connection.executeWithoutCommitting(new String[]{"INSERT INTO tablea VALUES(" + i + ", 'a')", "INSERT INTO tableb VALUES(" + i + ", 'b')"});
        }
        this.connection.commit();
        this.connection.setAutoCommit(true);
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1000, 'b')"});
        this.waitForAvailableRecords(30L, TimeUnit.SECONDS);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(15);
        List tableA = records.recordsForTopic("testdb.informix.tablea");
        List tableB = records.recordsForTopic("testdb.informix.tableb");
        List tx = records.recordsForTopic("testdb.transaction");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(6);
        Assertions.assertThat((List)tx).hasSize(4);
        List all = records.allRecordsInOrder();
        String txId = this.assertBeginTransaction((SourceRecord)all.get(0));
        for (int i = 1; i <= 10; ++i) {
            this.assertRecordTransactionMetadata((SourceRecord)all.get(i), txId, i, (i + 1) / 2);
        }
        this.assertEndTransaction((SourceRecord)all.get(11), txId, 10L, Collect.hashMapOf((Object)"testdb.informix.tablea", (Object)5, (Object)"testdb.informix.tableb", (Object)5));
    }
}

