/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.Lsn;
import io.debezium.connector.informix.Module;
import io.debezium.connector.informix.SourceInfo;
import io.debezium.relational.TableId;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private SourceInfo source;

    @Before
    public void beforeEach() {
        InformixConnectorConfig connectorConfig = new InformixConnectorConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "serverX")).with(InformixConnectorConfig.DATABASE_NAME, "c")).build());
        this.source = new SourceInfo(connectorConfig);
        this.source.setChangeLsn(Lsn.valueOf((Long)1L));
        this.source.setCommitLsn(Lsn.valueOf((Long)2L));
        this.source.setSnapshot(SnapshotRecord.TRUE);
        this.source.setSourceTime(Instant.ofEpochMilli(3000L));
        this.source.setTableId(new TableId("c", "s", "t"));
    }

    @Test
    public void versionIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)Module.version());
    }

    @Test
    public void connectorIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)Module.name());
    }

    @Test
    public void serverNameIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("name")).isEqualTo((Object)"serverX");
    }

    @Test
    public void changeLsnIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("change_lsn")).isEqualTo((Object)Long.toString(1L));
    }

    @Test
    public void commitLsnIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("commit_lsn")).isEqualTo((Object)Long.toString(2L));
    }

    @Test
    public void snapshotIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("snapshot")).isEqualTo((Object)"true");
    }

    @Test
    public void timestampIsPresent() {
        AssertionsForClassTypes.assertThat((Long)this.source.struct().getInt64("ts_ms")).isEqualTo(3000L);
    }

    @Test
    public void tableIdIsPresent() {
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("db")).isEqualTo((Object)"c");
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("schema")).isEqualTo((Object)"s");
        AssertionsForClassTypes.assertThat((String)this.source.struct().getString("table")).isEqualTo((Object)"t");
    }

    @Test
    public void schemaIsCorrect() {
        Schema schema = SchemaBuilder.struct().name("io.debezium.connector.informix.Source").field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("sequence", Schema.OPTIONAL_STRING_SCHEMA).field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("begin_lsn", Schema.OPTIONAL_STRING_SCHEMA).build();
        AssertionsForClassTypes.assertThat((Object)this.source.struct().schema()).isEqualTo((Object)schema);
    }
}

