/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.informix.InformixConnection;
import io.debezium.connector.informix.InformixConnector;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class InformixValidateColumnOrderIT
extends AbstractConnectorTest {
    private static final String testTableName = "test_column_order";
    private static final Map<String, String> testTableColumns = new LinkedHashMap<String, String>(){
        {
            this.put("id", "int");
            this.put("name", "varchar(50)");
            this.put("age", "int");
            this.put("gender", "char(10)");
            this.put("address", "varchar(50)");
        }
    };
    private InformixConnection connection;

    public static void assertRecordInRightOrder(Struct record, Map<String, String> recordToBeCheck) {
        recordToBeCheck.keySet().forEach(field -> Assertions.assertThat((String)record.get(field).toString().trim()).isEqualTo(recordToBeCheck.get(field)));
    }

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        String columns = testTableColumns.entrySet().stream().map(e -> (String)e.getKey() + " " + (String)e.getValue()).collect(Collectors.joining(", "));
        this.connection.execute(new String[]{String.format("create table %s(%s)", testTableName, columns)});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        InformixValidateColumnOrderIT.waitForConnectorShutdown((String)"informix_server", (String)"testdb");
        this.assertConnectorNotRunning();
        if (this.connection != null) {
            this.connection.rollback().execute(new String[]{String.format("drop table %s", testTableName)}).close();
        }
    }

    @Test
    public void testColumnOrderWhileInsert() throws Exception {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixValidateColumnOrderIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        InformixValidateColumnOrderIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        LinkedHashMap<String, String> recordToBeInsert = new LinkedHashMap<String, String>(){
            {
                this.put("id", "1");
                this.put("name", "cc");
                this.put("age", "18");
                this.put("gender", "male");
                this.put("address", "ff:ff:ff:ff:ff:ff");
            }
        };
        this.connection.execute(new String[]{String.format("insert into %s(%s) values(\"%s\")", testTableName, Strings.join((CharSequence)", ", recordToBeInsert.keySet()), Strings.join((CharSequence)"\", \"", recordToBeInsert.values()))});
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        String topicName = String.format("%s.informix.%s", "testdb", testTableName);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        List insertOne = sourceRecords.recordsForTopic(topicName);
        ((ListAssert)Assertions.assertThat((List)insertOne).isNotNull()).hasSize(1);
        SourceRecord insertedOneRecord = (SourceRecord)insertOne.get(0);
        Struct insertedOneValue = (Struct)insertedOneRecord.value();
        VerifyRecord.isValidInsert((SourceRecord)insertedOneRecord);
        InformixValidateColumnOrderIT.assertRecordInRightOrder((Struct)insertedOneValue.get("after"), (Map<String, String>)recordToBeInsert);
    }

    @Test
    public void testColumnOrderWhileUpdate() throws Exception {
        LinkedHashMap<String, String> recordToBeUpdate = new LinkedHashMap<String, String>(){
            {
                this.put("id", "2");
                this.put("name", "cc");
                this.put("age", "18");
                this.put("gender", "male");
                this.put("address", "ff:ff:ff:ff:ff:ff");
            }
        };
        this.connection.execute(new String[]{String.format("insert into %s(%s) values(\"%s\")", testTableName, Strings.join((CharSequence)", ", recordToBeUpdate.keySet()), Strings.join((CharSequence)"\", \"", recordToBeUpdate.values()))});
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixValidateColumnOrderIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        InformixValidateColumnOrderIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        LinkedHashMap<String, String> recordAfterUpdate = new LinkedHashMap<String, String>(recordToBeUpdate);
        recordAfterUpdate.put("address", "00:00:00:00:00:00");
        this.connection.execute(new String[]{String.format("update %s set address = \"%s\" where id = \"%s\"", testTableName, recordAfterUpdate.get("address"), recordToBeUpdate.get("id"))});
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        String topicName = String.format("%s.informix.%s", "testdb", testTableName);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        List updateOne = sourceRecords.recordsForTopic(topicName);
        ((ListAssert)Assertions.assertThat((List)updateOne).isNotNull()).hasSize(1);
        SourceRecord updatedOneRecord = (SourceRecord)updateOne.get(0);
        Struct updatedOneValue = (Struct)updatedOneRecord.value();
        VerifyRecord.isValidUpdate((SourceRecord)updatedOneRecord);
        InformixValidateColumnOrderIT.assertRecordInRightOrder((Struct)updatedOneValue.get("before"), (Map<String, String>)recordToBeUpdate);
        InformixValidateColumnOrderIT.assertRecordInRightOrder((Struct)updatedOneValue.get("after"), recordAfterUpdate);
    }

    @Test
    public void testColumnOrderWhileDelete() throws Exception {
        LinkedHashMap<String, String> recordToBeDelete = new LinkedHashMap<String, String>(){
            {
                this.put("id", "3");
                this.put("name", "cc");
                this.put("age", "18");
                this.put("gender", "male");
                this.put("address", "ff:ff:ff:ff:ff:ff");
            }
        };
        this.connection.execute(new String[]{String.format("insert into %s(%s) values(\"%s\")", testTableName, Strings.join((CharSequence)", ", recordToBeDelete.keySet()), Strings.join((CharSequence)"\", \"", recordToBeDelete.values()))});
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(InformixConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)InformixConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(CommonConnectorConfig.TOMBSTONES_ON_DELETE, false)).build();
        this.start(InformixConnector.class, config);
        this.assertConnectorIsRunning();
        InformixValidateColumnOrderIT.waitForSnapshotToBeCompleted((String)"informix_server", (String)"testdb");
        this.consumeRecords(0);
        InformixValidateColumnOrderIT.waitForStreamingRunning((String)"informix_server", (String)"testdb");
        this.connection.execute(new String[]{String.format("delete from %s where id = \"%s\"", testTableName, recordToBeDelete.get("id"))});
        this.waitForAvailableRecords(10L, TimeUnit.SECONDS);
        String topicName = String.format("%s.informix.%s", "testdb", testTableName);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        List deletedRecords = sourceRecords.recordsForTopic(topicName);
        ((ListAssert)Assertions.assertThat((List)deletedRecords).isNotNull()).hasSize(1);
        SourceRecord deletedOneRecord = (SourceRecord)deletedRecords.get(0);
        Struct deletedOneValue = (Struct)deletedOneRecord.value();
        VerifyRecord.isValidDelete((SourceRecord)deletedOneRecord);
        InformixValidateColumnOrderIT.assertRecordInRightOrder((Struct)deletedOneValue.get("before"), (Map<String, String>)recordToBeDelete);
    }
}

