/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import com.informix.jdbc.IfxColumnInfo;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.Lsn;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.List;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String CHANGE_LSN_KEY = "change_lsn";
    public static final String COMMIT_LSN_KEY = "commit_lsn";
    public static final String BEGIN_LSN_KEY = "begin_lsn";
    public static final String TX_ID = "txId";
    public static final String DEBEZIUM_VERSION_KEY = "version";
    public static final String DEBEZIUM_CONNECTOR_KEY = "connector";
    public static final String SERVER_NAME_KEY = "name";
    public static final String TIMESTAMP_KEY = "ts_ms";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String DATABASE_NAME_KEY = "db";
    public static final String SCHEMA_NAME_KEY = "schema";
    public static final String TABLE_NAME_KEY = "table";
    public static final String COLLECTION_NAME_KEY = "collection";
    private Lsn commitLsn = Lsn.NULL;
    private Lsn changeLsn = Lsn.NULL;
    private Integer txId = -1;
    private Lsn beginLsn = Lsn.NULL;
    private Instant sourceTime;
    private TableId tableId;
    private final String databaseName;
    private List<IfxColumnInfo> streamMetadata;

    public SourceInfo(InformixConnectorConfig config) {
        super((CommonConnectorConfig)config);
        this.databaseName = config.getDatabaseName();
    }

    public Lsn getCommitLsn() {
        return this.commitLsn;
    }

    public void setCommitLsn(Lsn commitLsn) {
        this.commitLsn = commitLsn;
    }

    public Lsn getChangeLsn() {
        return this.changeLsn;
    }

    public void setChangeLsn(Lsn changeLsn) {
        this.changeLsn = changeLsn;
    }

    public Integer getTxId() {
        return this.txId;
    }

    public void setTxId(Integer txId) {
        this.txId = txId;
    }

    public Lsn getBeginLsn() {
        return this.beginLsn;
    }

    public void setBeginLsn(Lsn beginLsn) {
        this.beginLsn = beginLsn;
    }

    public void setSourceTime(Instant instant) {
        this.sourceTime = instant;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    public String toString() {
        return "SourceInfo [serverName=" + this.serverName() + ", commitLsn=" + this.commitLsn + ", changeLsn=" + this.changeLsn + ", txId=" + this.txId + ", beginLsn=" + this.beginLsn + ", snapshot=" + this.snapshotRecord + ", sourceTime=" + this.sourceTime + "]";
    }

    protected Instant timestamp() {
        return this.sourceTime;
    }

    protected String database() {
        return this.databaseName;
    }
}

