/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import io.debezium.connector.Nullable;

public class Lsn
implements Comparable<Lsn>,
Nullable {
    public static final Lsn NULL = new Lsn(-1L);
    private static final long LO_MASK = Long.parseUnsignedLong("00000000ffffffff", 16);
    private static final long HI_MASK = Long.parseUnsignedLong("ffffffff00000000", 16);
    private final Long lsn;

    Lsn(Long lsn) {
        this.lsn = lsn;
    }

    public static Lsn valueOf(String lsn) {
        return lsn == null || lsn.equalsIgnoreCase("NULL") ? NULL : Lsn.valueOf(Long.parseLong(lsn));
    }

    public static Lsn valueOf(Long lsn) {
        return lsn == null ? NULL : new Lsn(lsn);
    }

    public boolean isAvailable() {
        return this.lsn != null && this.lsn >= 0L;
    }

    public String toString() {
        return Long.toString(this.lsn);
    }

    public String toLongString() {
        return String.format("LSN(%d:0x%x)", this.loguniq(), this.logpos());
    }

    public long logpos() {
        return LO_MASK & this.lsn;
    }

    public long loguniq() {
        return this.lsn >> 32;
    }

    public long longValue() {
        return this.lsn != null ? this.lsn : -1L;
    }

    public int hashCode() {
        return this.lsn.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && this.lsn.equals(((Lsn)obj).lsn);
    }

    @Override
    public int compareTo(Lsn o) {
        if (this == o) {
            return 0;
        }
        if (!this.isAvailable()) {
            if (!o.isAvailable()) {
                return 0;
            }
            return -1;
        }
        if (!o.isAvailable()) {
            return 1;
        }
        return this.lsn.compareTo(o.lsn);
    }

    public boolean isBetween(Lsn from, Lsn to) {
        return this.compareTo(from) >= 0 && this.compareTo(to) < 0;
    }

    public Lsn increment() {
        return Lsn.valueOf(this.lsn + 1L);
    }
}

