/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.informix;

import com.informix.jdbc.IfxDriver;
import io.debezium.config.Field;
import io.debezium.connector.informix.InformixConnectorConfig;
import io.debezium.connector.informix.Lsn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformixConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformixConnection.class);
    private static final String GET_DATABASE_NAME = "select dbinfo('dbname') from systables where tabid = 1";
    private static final String GET_MAX_LSN = "select max(seqnum) as seqnum from syscdcv1:informix.syscdctabs where dbname = '%s'";
    private static final String GET_CURRENT_TIMESTAMP = "SELECT CURRENT YEAR TO FRACTION(5)";
    private static final String QUOTED_CHARACTER = "";
    private static final String URL_PATTERN = "jdbc:informix-sqli://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}:user=${" + JdbcConfiguration.USER + "};password=${" + JdbcConfiguration.PASSWORD + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)IfxDriver.class.getName(), (ClassLoader)InformixConnection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(InformixConnectorConfig.PORT.defaultValueAsString())});
    private final String realDatabaseName = this.retrieveRealDatabaseName().trim();

    public InformixConnection(JdbcConfiguration config) {
        super(config, FACTORY, QUOTED_CHARACTER, QUOTED_CHARACTER);
    }

    public Lsn getMaxLsn() {
        return Lsn.valueOf(0L);
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    private String retrieveRealDatabaseName() {
        try {
            return (String)this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    public String connectionString() {
        return this.connectionString(URL_PATTERN);
    }

    public Optional<Instant> getCurrentTimestamp() throws SQLException {
        return (Optional)this.queryAndMap(GET_CURRENT_TIMESTAMP, rs -> rs.next() ? Optional.of(rs.getTimestamp(1).toInstant()) : Optional.empty());
    }

    public String quotedTableIdString(TableId tableId) {
        String schemaName;
        StringBuilder builder = new StringBuilder();
        String catalogName = tableId.catalog();
        if (!Strings.isNullOrBlank((String)catalogName)) {
            builder.append(catalogName).append(':');
        }
        if (!Strings.isNullOrBlank((String)(schemaName = tableId.schema()))) {
            builder.append(schemaName).append('.');
        }
        return builder.append(tableId.table()).toString();
    }

    public String quotedColumnIdString(String columnName) {
        return columnName;
    }
}

