/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.junit.After;
import org.junit.Before;

public class NotificationsIT
extends AbstractNotificationsIT<Db2Connector> {
    private Db2Connection connection;

    @Before
    public void before() throws SQLException {
        TestHelper.dropAllTables();
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int not null, cola varchar(30), primary key (id))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "TABLEA");
        TestHelper.enableDbCdc(this.connection);
        this.connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER = 'DB2INST1'"});
        TestHelper.refreshAndWait(this.connection);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "TABLEA");
            this.connection.execute(new String[]{"DROP TABLE tablea"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    protected Class<Db2Connector> connectorClass() {
        return Db2Connector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL);
    }

    protected String connector() {
        return "db2_server";
    }

    protected String server() {
        return "testdb";
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }

    protected List<String> collections() {
        return List.of("DB2INST1.TABLEA");
    }
}

