/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.Module;
import io.debezium.connector.db2.SourceInfo;
import io.debezium.relational.TableId;
import java.time.Instant;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SourceInfoTest {
    private SourceInfo source;

    @Before
    public void beforeEach() {
        Db2ConnectorConfig connectorConfig = new Db2ConnectorConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "serverX")).with(Db2ConnectorConfig.DATABASE_NAME, "c")).build());
        this.source = new SourceInfo(connectorConfig);
        this.source.setChangeLsn(Lsn.valueOf((byte[])new byte[]{1}));
        this.source.setCommitLsn(Lsn.valueOf((byte[])new byte[]{2}));
        this.source.setSnapshot(SnapshotRecord.TRUE);
        this.source.setSourceTime(Instant.ofEpochMilli(3000L));
        this.source.setTableId(new TableId("c", "s", "t"));
    }

    @Test
    public void versionIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("version")).isEqualTo((Object)Module.version());
    }

    @Test
    public void connectorIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("connector")).isEqualTo((Object)Module.name());
    }

    @Test
    public void serverNameIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("name")).isEqualTo((Object)"serverX");
    }

    @Test
    public void changeLsnIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("change_lsn")).isEqualTo((Object)Lsn.valueOf((byte[])new byte[]{1}).toString());
    }

    @Test
    public void commitLsnIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("commit_lsn")).isEqualTo((Object)Lsn.valueOf((byte[])new byte[]{2}).toString());
    }

    @Test
    public void snapshotIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("snapshot")).isEqualTo((Object)"true");
    }

    @Test
    public void timestampIsPresent() {
        Assertions.assertThat((Long)this.source.struct().getInt64("ts_ms")).isEqualTo(3000L);
    }

    @Test
    public void tableIdIsPresent() {
        Assertions.assertThat((String)this.source.struct().getString("db")).isEqualTo((Object)"c");
        Assertions.assertThat((String)this.source.struct().getString("schema")).isEqualTo((Object)"s");
        Assertions.assertThat((String)this.source.struct().getString("table")).isEqualTo((Object)"t");
    }

    @Test
    public void schemaIsCorrect() {
        Schema schema = SchemaBuilder.struct().name("io.debezium.connector.db2.Source").field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", AbstractSourceInfoStructMaker.SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("sequence", Schema.OPTIONAL_STRING_SCHEMA).field("ts_us", Schema.OPTIONAL_INT64_SCHEMA).field("ts_ns", Schema.OPTIONAL_INT64_SCHEMA).field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).build();
        Assertions.assertThat((Object)this.source.struct().schema()).isEqualTo((Object)schema);
    }
}

