/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.SkipTestRule;
import io.debezium.pipeline.AbstractBlockingSnapshotTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public class BlockingSnapshotIT
extends AbstractBlockingSnapshotTest {
    private Db2Connection connection;
    @Rule
    public SkipTestRule skipRule = new SkipTestRule();

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        TestHelper.disableDbCdc(this.connection);
        TestHelper.disableTableCdc(this.connection, "A");
        TestHelper.disableTableCdc(this.connection, "B");
        TestHelper.disableTableCdc(this.connection, "DEBEZIUM_SIGNAL");
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS a", "DROP TABLE IF EXISTS b", "DROP TABLE IF EXISTS debezium_signal"});
        this.connection.execute(new String[]{"CREATE TABLE a (pk int not null, aa int, primary key (pk))", "CREATE TABLE b (pk int not null, aa int, primary key (pk))", "CREATE TABLE debezium_signal (id varchar(64), type varchar(32), data varchar(2048))"});
        TestHelper.enableDbCdc(this.connection);
        this.connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER = 'DB2INST1'"});
        TestHelper.refreshAndWait(this.connection);
        TestHelper.enableTableCdc(this.connection, "DEBEZIUM_SIGNAL");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "A");
            TestHelper.disableTableCdc(this.connection, "B");
            TestHelper.disableTableCdc(this.connection, "DEBEZIUM_SIGNAL");
            this.connection.rollback();
            this.connection.execute(new String[]{"DROP TABLE IF EXISTS a", "DROP TABLE IF EXISTS b", "DROP TABLE IF EXISTS debezium_signal"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    protected void populateTable() throws SQLException {
        super.populateTable((JdbcConnection)this.connection);
        TestHelper.enableTableCdc(this.connection, "A");
    }

    protected void populateTables() throws SQLException {
        super.populateTables();
        TestHelper.enableTableCdc(this.connection, "A");
        TestHelper.enableTableCdc(this.connection, "B");
    }

    protected Class<Db2Connector> connectorClass() {
        return Db2Connector.class;
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        return this.config();
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "testdb.DB2INST1.A";
    }

    protected List<String> topicNames() {
        return List.of(this.topicName(), "testdb.DB2INST1.B");
    }

    protected String tableName() {
        return "DB2INST1.A";
    }

    protected List<String> tableNames() {
        return List.of(this.tableName(), "DB2INST1.B");
    }

    protected String signalTableName() {
        return "DEBEZIUM_SIGNAL";
    }

    protected String escapedTableDataCollectionId() {
        return "\\\"DB2INST1\\\".\\\"A\\\"";
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.SIGNAL_DATA_COLLECTION, "DB2INST1.DEBEZIUM_SIGNAL")).with(Db2ConnectorConfig.SNAPSHOT_MODE_TABLES, "DB2INST1.A")).with(Db2ConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250);
    }

    protected String pkFieldName() {
        return "PK";
    }

    protected String valueFieldName() {
        return "AA";
    }

    protected String connector() {
        return "db2_server";
    }

    protected String server() {
        return "testdb";
    }

    protected int insertMaxSleep() {
        return 100;
    }
}

