/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.AbstractDb2DefaultValueIT;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.junit.ConditionalFail;
import io.debezium.junit.Flaky;
import io.debezium.relational.TableId;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class ZZZDb2OnlineDefaultValueIT
extends AbstractDb2DefaultValueIT {
    @Rule
    public TestRule conditionalFail = new ConditionalFail();

    @Override
    @Test
    @Flaky(value="DBZ-6048")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleDateTimeDefaultTypes() throws Exception {
        super.shouldHandleDateTimeDefaultTypes();
    }

    @Override
    protected void performSchemaChange(Configuration config, Db2Connection connection, String alterStatement) throws Exception {
        TableId tableId = TableId.parse((String)"DB2INST1.DV_TEST");
        connection.lockTable(tableId);
        String sourceTable = alterStatement.replace("%table%", tableId.table());
        String changeTable = alterStatement.replace("%table%", TestHelper.getCdcTableName(connection, tableId.table()));
        connection.execute(new String[]{sourceTable});
        connection.execute(new String[]{changeTable});
        TestHelper.deactivateTable(connection, tableId.table());
        TestHelper.activeTable(connection, tableId.table());
    }
}

