/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.AbstractReselectProcessorTest;
import io.debezium.processors.reselect.ReselectColumnsPostProcessor;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.junit.After;
import org.junit.Before;

public class Db2ReselectColumnsProcessorIT
extends AbstractReselectProcessorTest<Db2Connector> {
    private Db2Connection connection;

    @Before
    public void beforeEach() throws Exception {
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        block11: {
            try {
                super.afterEach();
                if (this.connection == null) break block11;
            }
            catch (Throwable throwable) {
                if (this.connection != null) {
                    try {
                        TestHelper.disableDbCdc(this.connection);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        TestHelper.disableTableCdc(this.connection, "DBZ4321");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.connection.execute(new String[]{"DROP TABLE dbz4321 IF EXISTS"});
                    this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
                    this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
                    this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
                    this.connection.close();
                }
                throw throwable;
            }
            try {
                TestHelper.disableDbCdc(this.connection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                TestHelper.disableTableCdc(this.connection, "DBZ4321");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.connection.execute(new String[]{"DROP TABLE dbz4321 IF EXISTS"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    protected Class<Db2Connector> getConnectorClass() {
        return Db2Connector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "DB2INST1\\.DBZ4321")).with(Db2ConnectorConfig.CUSTOM_POST_PROCESSORS, "reselector")).with("reselector.type", ReselectColumnsPostProcessor.class.getName());
    }

    protected String topicName() {
        return "testdb.DB2INST1.DBZ4321";
    }

    protected String tableName() {
        return "DB2INST1.DBZ4321";
    }

    protected String reselectColumnsList() {
        return "DB2INST1.DBZ4321:DATA";
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"DROP TABLE DBZ4321 IF EXISTS"});
        TestHelper.enableDbCdc(this.connection);
        this.connection.execute(new String[]{"CREATE TABLE DBZ4321 (id int not null, data varchar(50), data2 int, primary key(id))"});
    }

    protected void dropTable() throws Exception {
    }

    protected String getInsertWithValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,'one',1)";
    }

    protected String getInsertWithNullValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,null,1)";
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        Db2ReselectColumnsProcessorIT.waitForStreamingRunning((String)"db2_server", (String)"testdb");
    }

    protected String fieldName(String fieldName) {
        return fieldName.toUpperCase();
    }

    protected void enableTableForCdc() throws Exception {
        this.connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER = 'DB2INST1'"});
        TestHelper.refreshAndWait(this.connection);
        TestHelper.enableTableCdc(this.connection, "DBZ4321");
    }
}

