/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DatatypesFromSnapshotIT
extends AbstractConnectorTest {
    private Db2Connection connection;
    private static final String[] CREATE_TABLES = new String[]{"CREATE TABLE dt_numeric (id int not null, df decfloat, df16 decfloat(16), df34 decfloat(34), primary key (id))"};
    private static final String[] INSERT_DATA = new String[]{"INSERT INTO dt_numeric VALUES(1, 1, 3.123456789012345678, 3.012345678901234567890123456789)"};

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS dt_numeric"});
        this.connection.execute(CREATE_TABLES);
        this.connection.execute(INSERT_DATA);
        TestHelper.enableTableCdc(this.connection, "DT_NUMERIC");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "DT_NUMERIC");
            this.connection.execute(new String[]{"DROP TABLE dt_numeric"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    @Test
    public void numericTypesPrecise() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "db2inst1.dt_numeric")).build();
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        SourceRecord rec = (SourceRecord)records.allRecordsInOrder().get(0);
        this.assertVariableScaleDecimal(((Struct)rec.value()).getStruct("after").get("DF"), new BigDecimal("1"));
        this.assertVariableScaleDecimal(((Struct)rec.value()).getStruct("after").get("DF16"), new BigDecimal("3.123456789012346"));
        this.assertVariableScaleDecimal(((Struct)rec.value()).getStruct("after").get("DF34"), new BigDecimal("3.012345678901234567890123456789"));
        this.stopConnector();
    }

    @Test
    public void numericTypesDouble() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "db2inst1.dt_numeric")).with(Db2ConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        SourceRecord rec = (SourceRecord)records.allRecordsInOrder().get(0);
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF")).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF16")).isEqualTo((Object)3.123456789012346);
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF34")).isEqualTo((Object)3.0123456789012346);
        this.stopConnector();
    }

    @Test
    public void numericTypesString() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "db2inst1.dt_numeric")).with(Db2ConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        SourceRecord rec = (SourceRecord)records.allRecordsInOrder().get(0);
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF")).isEqualTo((Object)"1");
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF16")).isEqualTo((Object)"3.123456789012346");
        Assertions.assertThat((Object)((Struct)rec.value()).getStruct("after").get("DF34")).isEqualTo((Object)"3.012345678901234567890123456789");
        this.stopConnector();
    }

    private void assertVariableScaleDecimal(Object actual, BigDecimal expected) {
        Struct v = (Struct)actual;
        Assertions.assertThat((Object)v.get("scale")).isEqualTo((Object)expected.scale());
        Assertions.assertThat((Object)v.get("value")).isEqualTo((Object)expected.unscaledValue().toByteArray());
    }
}

