/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.bean.StandardBeanNames;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.snapshot.query.SelectAllSnapshotQuery;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CustomTestSnapshot
extends SelectAllSnapshotQuery
implements Snapshotter,
BeanRegistryAware {
    private boolean hasState;

    public String name() {
        return CustomTestSnapshot.class.getName();
    }

    public void injectBeanRegistry(BeanRegistry beanRegistry) {
        Offsets db2OffsetContextOffsets = (Offsets)beanRegistry.lookupByName(StandardBeanNames.OFFSETS, Offsets.class);
        for (Db2OffsetContext offset : db2OffsetContextOffsets.getOffsets().values()) {
            this.hasState = offset != null;
        }
    }

    public boolean shouldSnapshotData(boolean offsetExists, boolean snapshotInProgress) {
        return true;
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshotSchema(boolean offsetExists, boolean snapshotInProgress) {
        return true;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }

    public Optional<String> snapshotQuery(String tableId, List<String> snapshotSelectColumns) {
        if (!this.hasState && tableId.contains("TABLEB")) {
            return Optional.empty();
        }
        String query = snapshotSelectColumns.stream().collect(Collectors.joining(", ", "SELECT ", " FROM " + tableId));
        return Optional.of(query);
    }
}

