/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.rest.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataCollection {
    private final String namespace;
    private final String name;
    private final String realm;

    public DataCollection(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.realm = null;
    }

    public DataCollection(String realm, String namespace, String name) {
        this.realm = realm;
        this.namespace = namespace;
        this.name = name;
    }

    @JsonGetter(value="identifier")
    public String identifier() {
        if (null == this.realm || "null".equals(this.realm)) {
            return this.namespace + "." + this.name;
        }
        return this.realm + "." + this.namespace + "." + this.name;
    }

    @JsonGetter(value="realm")
    public String realm() {
        return this.realm;
    }

    @JsonGetter(value="namespace")
    public String namespace() {
        return this.namespace;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DataCollection{realm='" + this.realm + "', namespace='" + this.namespace + "', name='" + this.name + "'}";
    }
}

