/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.AbstractDb2DefaultValueIT;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import org.junit.Before;

public class Db2OfflineDefaultValueIT
extends AbstractDb2DefaultValueIT {
    @Override
    @Before
    public void before() throws SQLException {
        super.before();
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
    }

    @Override
    protected void performSchemaChange(Configuration config, Db2Connection connection, String alterStatement) throws Exception {
        this.stopConnector();
        TableId tableId = TableId.parse((String)"DB2INST1.DV_TEST");
        TestHelper.deactivateTable(connection, tableId.table());
        TestHelper.disableTableCdc(connection, tableId.table());
        String sourceTable = alterStatement.replace("%table%", tableId.table());
        connection.execute(new String[]{sourceTable});
        TestHelper.enableTableCdc(connection, tableId.table());
        TestHelper.activeTable(connection, tableId.table());
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        Db2OfflineDefaultValueIT.waitForStreamingRunning((String)"db2_server", (String)"testdb");
    }
}

