/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Db2CaseSensitiveObjectIT
extends AbstractConnectorTest {
    private Db2Connection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"CREATE TABLE \"testSchema\".\"tablea\" (id int not null, cola varchar(30), primary key (id))", "INSERT INTO \"testSchema\".\"tablea\" VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "testSchema", "tablea");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "testSchema", "tablea");
            this.connection.execute(new String[]{"DROP TABLE \"testSchema\".\"tablea\""});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-2796"})
    public void testCaseSensitiveSchemaAndTable() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "testSchema.tablea")).build();
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        TestHelper.enableDbCdc(this.connection);
        this.connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER = 'testSchema'"});
        TestHelper.refreshAndWait(this.connection);
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO \"testSchema\".\"tablea\" VALUES(" + id + ", 'a')"});
        }
        TestHelper.refreshAndWait(this.connection);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(5);
        List tableA = records.recordsForTopic("testdb.testSchema.tablea");
        Assertions.assertThat((List)tableA).hasSize(5);
        this.stopConnector();
    }
}

