/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Db2Partition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public Db2Partition(String serverName) {
        this.serverName = serverName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Db2Partition other = (Db2Partition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    public String toString() {
        return "Db2Partition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    static class Provider
    implements Partition.Provider<Db2Partition> {
        private final Db2ConnectorConfig connectorConfig;

        Provider(Db2ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<Db2Partition> getPartitions() {
            return Collections.singleton(new Db2Partition(this.connectorConfig.getLogicalName()));
        }
    }
}

