/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.pipeline.notification.AbstractNotificationsIT;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public class NotificationsIT
extends AbstractNotificationsIT<Db2Connector> {
    private Db2Connection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            this.connection.close();
        }
    }

    protected Class<Db2Connector> connectorClass() {
        return Db2Connector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL);
    }

    protected String connector() {
        return "db2_server";
    }

    protected String database() {
        return "testdb";
    }

    protected String server() {
        return "testdb";
    }

    protected String snapshotStatusResult() {
        return "COMPLETED";
    }
}

