/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2ChangeRecordEmitter;
import io.debezium.connector.db2.Db2ChangeTable;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.Db2SchemaChangeEventEmitter;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.TxLogPosition;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeTableResultSet;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.ChangeTable;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2StreamingChangeEventSource
implements StreamingChangeEventSource<Db2Partition, Db2OffsetContext> {
    private static final int COL_COMMIT_LSN = 2;
    private static final int COL_ROW_LSN = 3;
    private static final int COL_OPERATION = 1;
    private static final int COL_DATA = 5;
    private static final Pattern MISSING_CDC_FUNCTION_CHANGES_ERROR = Pattern.compile("Invalid object name 'cdc.fn_cdc_get_all_changes_(.*)'\\.");
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2StreamingChangeEventSource.class);
    private final Db2Connection dataConnection;
    private final Db2Connection metadataConnection;
    private final EventDispatcher<Db2Partition, TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final Db2DatabaseSchema schema;
    private final Duration pollInterval;
    private final Db2ConnectorConfig connectorConfig;

    public Db2StreamingChangeEventSource(Db2ConnectorConfig connectorConfig, Db2Connection dataConnection, Db2Connection metadataConnection, EventDispatcher<Db2Partition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, Db2DatabaseSchema schema) {
        this.connectorConfig = connectorConfig;
        this.dataConnection = dataConnection;
        this.metadataConnection = metadataConnection;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.pollInterval = connectorConfig.getPollInterval();
    }

    public void execute(ChangeEventSource.ChangeEventSourceContext context, Db2Partition partition, Db2OffsetContext offsetContext) throws InterruptedException {
        if (!this.connectorConfig.getSnapshotMode().shouldStream()) {
            LOGGER.info("Streaming is not enabled in current configuration");
            return;
        }
        Metronome metronome = Metronome.sleeper((Duration)this.pollInterval, (Clock)this.clock);
        PriorityQueue<Db2ChangeTable> schemaChangeCheckpoints = new PriorityQueue<Db2ChangeTable>((x, y) -> x.getStopLsn().compareTo(y.getStopLsn()));
        try {
            AtomicReference<Db2ChangeTable[]> tablesSlot = new AtomicReference<Db2ChangeTable[]>(this.getCdcTablesToQuery(partition, offsetContext));
            TxLogPosition lastProcessedPositionOnStart = offsetContext.getChangePosition();
            long lastProcessedEventSerialNoOnStart = offsetContext.getEventSerialNo();
            LOGGER.info("Last position recorded in offsets is {}[{}]", (Object)lastProcessedPositionOnStart, (Object)lastProcessedEventSerialNoOnStart);
            TxLogPosition lastProcessedPosition = lastProcessedPositionOnStart;
            boolean shouldIncreaseFromLsn = offsetContext.isSnapshotCompleted();
            while (context.isRunning()) {
                Lsn currentMaxLsn = this.dataConnection.getMaxLsn();
                if (!currentMaxLsn.isAvailable()) {
                    LOGGER.warn("No maximum LSN recorded in the database; please ensure that the DB2 Agent is running");
                    metronome.pause();
                    continue;
                }
                if (currentMaxLsn.equals(lastProcessedPosition.getCommitLsn()) && shouldIncreaseFromLsn) {
                    LOGGER.debug("No change in the database");
                    metronome.pause();
                    continue;
                }
                Lsn fromLsn = lastProcessedPosition.getCommitLsn().isAvailable() && shouldIncreaseFromLsn ? this.dataConnection.incrementLsn(lastProcessedPosition.getCommitLsn()) : lastProcessedPosition.getCommitLsn();
                shouldIncreaseFromLsn = true;
                while (!schemaChangeCheckpoints.isEmpty()) {
                    this.migrateTable(partition, offsetContext, schemaChangeCheckpoints);
                }
                if (!this.dataConnection.listOfNewChangeTables(fromLsn, currentMaxLsn).isEmpty()) {
                    Db2ChangeTable[] tables = this.getCdcTablesToQuery(partition, offsetContext);
                    tablesSlot.set(tables);
                    for (Db2ChangeTable table : tables) {
                        if (!table.getStartLsn().isBetween(fromLsn, currentMaxLsn.increment())) continue;
                        LOGGER.info("Schema will be changed for {}", (Object)table);
                        schemaChangeCheckpoints.add(table);
                    }
                }
                try {
                    this.dataConnection.getChangesForTables(tablesSlot.get(), fromLsn, currentMaxLsn, resultSets -> {
                        long eventSerialNoInInitialTx = 1L;
                        int tableCount = resultSets.length;
                        ChangeTablePointer[] changeTables = new ChangeTablePointer[tableCount];
                        Db2ChangeTable[] tables = (Db2ChangeTable[])tablesSlot.get();
                        for (int i = 0; i < tableCount; ++i) {
                            changeTables[i] = new ChangeTablePointer(tables[i], resultSets[i]);
                            changeTables[i].next();
                        }
                        while (true) {
                            ChangeTablePointer tableWithSmallestLsn = null;
                            for (ChangeTablePointer changeTable : changeTables) {
                                if (changeTable.isCompleted() || tableWithSmallestLsn != null && changeTable.compareTo(tableWithSmallestLsn) >= 0) continue;
                                tableWithSmallestLsn = changeTable;
                            }
                            if (tableWithSmallestLsn == null) break;
                            if (!((TxLogPosition)tableWithSmallestLsn.getChangePosition()).isAvailable() || !((TxLogPosition)tableWithSmallestLsn.getChangePosition()).getInTxLsn().isAvailable()) {
                                LOGGER.error("Skipping change {} as its LSN is NULL which is not expected", (Object)tableWithSmallestLsn);
                                tableWithSmallestLsn.next();
                                continue;
                            }
                            if (((TxLogPosition)tableWithSmallestLsn.getChangePosition()).compareTo(lastProcessedPositionOnStart) < 0) {
                                LOGGER.info("Skipping change {} as its position is smaller than the last recorded position {}", (Object)tableWithSmallestLsn, (Object)lastProcessedPositionOnStart);
                                tableWithSmallestLsn.next();
                                continue;
                            }
                            if (((TxLogPosition)tableWithSmallestLsn.getChangePosition()).compareTo(lastProcessedPositionOnStart) == 0 && eventSerialNoInInitialTx <= lastProcessedEventSerialNoOnStart) {
                                LOGGER.info("Skipping change {} as its order in the transaction {} is smaller than or equal to the last recorded operation {}[{}]", new Object[]{tableWithSmallestLsn, eventSerialNoInInitialTx, lastProcessedPositionOnStart, lastProcessedEventSerialNoOnStart});
                                ++eventSerialNoInInitialTx;
                                tableWithSmallestLsn.next();
                                continue;
                            }
                            if (((Db2ChangeTable)tableWithSmallestLsn.getChangeTable()).getStopLsn().isAvailable() && ((Db2ChangeTable)tableWithSmallestLsn.getChangeTable()).getStopLsn().compareTo(((TxLogPosition)tableWithSmallestLsn.getChangePosition()).getCommitLsn()) <= 0) {
                                LOGGER.debug("Skipping table change {} as its stop LSN is smaller than the last recorded LSN {}", (Object)tableWithSmallestLsn, (Object)tableWithSmallestLsn.getChangePosition());
                                tableWithSmallestLsn.next();
                                continue;
                            }
                            LOGGER.trace("Processing change {}", (Object)tableWithSmallestLsn);
                            if (!schemaChangeCheckpoints.isEmpty() && ((TxLogPosition)tableWithSmallestLsn.getChangePosition()).getCommitLsn().compareTo(((Db2ChangeTable)((Object)((Object)schemaChangeCheckpoints.peek()))).getStopLsn()) >= 0) {
                                this.migrateTable(partition, offsetContext, schemaChangeCheckpoints);
                            }
                            TableId tableId = ((Db2ChangeTable)tableWithSmallestLsn.getChangeTable()).getSourceTableId();
                            int operation = tableWithSmallestLsn.getOperation();
                            Object[] data = tableWithSmallestLsn.getData();
                            int eventCount = 1;
                            if (operation == 3) {
                                if (!tableWithSmallestLsn.next() || tableWithSmallestLsn.getOperation() != 4) {
                                    throw new IllegalStateException("The update before event at " + tableWithSmallestLsn.getChangePosition() + " for table " + tableId + " was not followed by after event.\n Please report this as a bug together with a events around given LSN.");
                                }
                                eventCount = 2;
                            }
                            Object[] dataNext = operation == 3 ? tableWithSmallestLsn.getData() : null;
                            offsetContext.setChangePosition((TxLogPosition)tableWithSmallestLsn.getChangePosition(), eventCount);
                            offsetContext.event((DataCollectionId)((Db2ChangeTable)tableWithSmallestLsn.getChangeTable()).getSourceTableId(), this.metadataConnection.timestampOfLsn(((TxLogPosition)tableWithSmallestLsn.getChangePosition()).getCommitLsn()));
                            this.dispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new Db2ChangeRecordEmitter(partition, (OffsetContext)offsetContext, operation, data, dataNext, this.clock));
                            tableWithSmallestLsn.next();
                        }
                    });
                    lastProcessedPosition = TxLogPosition.valueOf(currentMaxLsn);
                    this.dataConnection.rollback();
                }
                catch (SQLException e) {
                    tablesSlot.set(this.processErrorFromChangeTableQuery(e, tablesSlot.get()));
                }
            }
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
    }

    private void migrateTable(Db2Partition partition, Db2OffsetContext offsetContext, Queue<Db2ChangeTable> schemaChangeCheckpoints) throws InterruptedException, SQLException {
        Db2ChangeTable newTable = schemaChangeCheckpoints.poll();
        LOGGER.info("Migrating schema to {}", (Object)newTable);
        Table tableSchema = this.metadataConnection.getTableSchemaFromTable(newTable);
        offsetContext.event((DataCollectionId)newTable.getSourceTableId(), Instant.now());
        this.dispatcher.dispatchSchemaChangeEvent((Partition)partition, (DataCollectionId)newTable.getSourceTableId(), (SchemaChangeEventEmitter)new Db2SchemaChangeEventEmitter(partition, offsetContext, newTable, tableSchema, this.schema, SchemaChangeEvent.SchemaChangeEventType.ALTER));
        newTable.setSourceTable(tableSchema);
    }

    private Db2ChangeTable[] processErrorFromChangeTableQuery(SQLException exception, Db2ChangeTable[] currentChangeTables) throws Exception {
        Matcher m = MISSING_CDC_FUNCTION_CHANGES_ERROR.matcher(exception.getMessage());
        if (m.matches()) {
            String captureName = m.group(1);
            LOGGER.info("Table is no longer captured with capture instance {}", (Object)captureName);
            return Arrays.asList(currentChangeTables).stream().filter(x -> !x.getCaptureInstance().equals(captureName)).collect(Collectors.toList()).toArray(new Db2ChangeTable[0]);
        }
        throw exception;
    }

    private Db2ChangeTable[] getCdcTablesToQuery(Db2Partition partition, Db2OffsetContext offsetContext) throws SQLException, InterruptedException {
        Map<TableId, List<Db2ChangeTable>> includedAndCdcEnabledTables;
        Set<Db2ChangeTable> cdcEnabledTables = this.dataConnection.listOfChangeTables();
        if (cdcEnabledTables.isEmpty()) {
            LOGGER.warn("No table has enabled CDC or security constraints prevents getting the list of change tables");
        }
        if ((includedAndCdcEnabledTables = cdcEnabledTables.stream().filter(changeTable -> {
            if (this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(changeTable.getSourceTableId())) {
                return true;
            }
            LOGGER.info("CDC is enabled for table {} but the table is not included by connector", (Object)changeTable);
            return false;
        }).collect(Collectors.groupingBy(x -> x.getSourceTableId()))).isEmpty()) {
            LOGGER.warn("After applying the include/exclude list filters, no changes will be captured. Please check your configuration!");
        }
        ArrayList<Db2ChangeTable> tables = new ArrayList<Db2ChangeTable>();
        for (List<Db2ChangeTable> captures : includedAndCdcEnabledTables.values()) {
            Db2ChangeTable currentTable = captures.get(0);
            if (captures.size() > 1) {
                Db2ChangeTable futureTable;
                if (captures.get(0).getStartLsn().compareTo(captures.get(1).getStartLsn()) < 0) {
                    futureTable = captures.get(1);
                } else {
                    currentTable = captures.get(1);
                    futureTable = captures.get(0);
                }
                currentTable.setStopLsn(futureTable.getStartLsn());
                tables.add(futureTable);
                LOGGER.info("Multiple capture instances present for the same table: {} and {}", (Object)currentTable, (Object)futureTable);
            }
            if (this.schema.tableFor(currentTable.getSourceTableId()) == null) {
                LOGGER.info("Table {} is new to be monitored by capture instance {}", (Object)currentTable.getSourceTableId(), (Object)currentTable.getCaptureInstance());
                offsetContext.event((DataCollectionId)currentTable.getSourceTableId(), Instant.now());
                this.dispatcher.dispatchSchemaChangeEvent((Partition)partition, (DataCollectionId)currentTable.getSourceTableId(), (SchemaChangeEventEmitter)new Db2SchemaChangeEventEmitter(partition, offsetContext, currentTable, this.dataConnection.getTableSchemaFromTable(currentTable), this.schema, SchemaChangeEvent.SchemaChangeEventType.CREATE));
            }
            tables.add(currentTable);
        }
        return tables.toArray(new Db2ChangeTable[tables.size()]);
    }

    private static class ChangeTablePointer
    extends ChangeTableResultSet<Db2ChangeTable, TxLogPosition> {
        ChangeTablePointer(Db2ChangeTable changeTable, ResultSet resultSet) {
            super((ChangeTable)changeTable, resultSet, 5);
        }

        protected int getOperation(ResultSet resultSet) throws SQLException {
            return resultSet.getInt(1);
        }

        protected TxLogPosition getNextChangePosition(ResultSet resultSet) throws SQLException {
            return this.isCompleted() ? TxLogPosition.NULL : TxLogPosition.valueOf(Lsn.valueOf(resultSet.getBytes(2)), Lsn.valueOf(resultSet.getBytes(3)));
        }
    }
}

