/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractDb2DefaultValueIT
extends AbstractConnectorTest {
    private Db2Connection connection;
    private Configuration config;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        TestHelper.disableDbCdc(this.connection);
        TestHelper.disableTableCdc(this.connection, "DV_TEST");
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"DROP TABLE IF EXISTS dv_test"});
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "DV_TEST");
            this.connection.execute(new String[]{"DROP TABLE IF EXISTS dv_test"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    @Test
    @Ignore(value="The ASN capture process does to not capture changes for a table using boolean data types.")
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleBooleanDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_boolean", "boolean", "true", "false", true, false, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleNumericDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_bigint", "bigint", "1", "2", 1L, 2L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_integer", "integer", "1", "2", 1, 2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_smallint", "smallint", "1", "2", (short)1, (short)2, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleFloatPointDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_decimal", "decimal(5,2)", "3.14", "6.28", BigDecimal.valueOf(3.14), BigDecimal.valueOf(6.28), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_numeric", "numeric(5,2)", "3.14", "6.28", BigDecimal.valueOf(3.14), BigDecimal.valueOf(6.28), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_double", "double", "3.14", "6.28", 3.14, 6.28, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_float", "float", "3.14", "6.28", 3.14, 6.28, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_real", "real", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleCharacterDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_varchar", "varchar(100)", "'hello'", "'world'", "hello", "world", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nvarchar", "nvarchar(100)", "'cedric'", "'entertainer'", "cedric", "entertainer", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_char", "char(5)", "'YES'", "'NO'", "YES  ", "NO   ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nchar", "nchar(5)", "'ON'", "'OFF'", "ON   ", "OFF  ", AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-4990"})
    public void shouldHandleDateTimeDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_date", "date", "'2022-01-01'", "'2022-01-02'", 18993, 18994, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_datetime", "datetime", "'2022-01-01 01:02:03'", "'2022-01-02 01:02:03'", 1640998923000000L, 1641085323000000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_time", "time", "'01:02:03'", "'02:03:04'", 3723000, 7384000, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_timestamp", "timestamp", "'2022-01-01 01:02:03'", "'2022-01-02 01:02:03'", 1640998923000000L, 1641085323000000L, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    protected abstract void performSchemaChange(Configuration var1, Db2Connection var2, String var3) throws Exception;

    private void shouldHandleDefaultValuesCommon(List<ColumnDefinition> columnDefinitions) throws Exception {
        this.testDefaultValuesCreateTableAndSnapshot(columnDefinitions);
        this.testDefaultValuesAlterTableModifyExisting(columnDefinitions);
        this.testDefaultValuesAlterTableAdd(columnDefinitions);
        this.TestDefaultValuesByRestartAndLoadingHistoryTopic();
    }

    private void TestDefaultValuesByRestartAndLoadingHistoryTopic() throws Exception {
        this.stopConnector();
        this.start(Db2Connector.class, this.config);
        this.assertConnectorIsRunning();
        AbstractDb2DefaultValueIT.waitForStreamingRunning((String)"db2_server", (String)"testdb");
    }

    private void testDefaultValuesCreateTableAndSnapshot(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder createSql = new StringBuilder();
        createSql.append("CREATE TABLE dv_test (id int not null");
        for (ColumnDefinition column : columnDefinitions) {
            createSql.append(", ").append(column.name).append(" ").append(column.definition).append(" ").append("default ").append(column.addDefaultValue);
            createSql.append(", ").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("default null");
            if (!column.temporalType) continue;
            String currentDefaultValue = column.getCurrentRegister();
            createSql.append(", ").append(column.name).append("_sysdate").append(" ").append(column.definition).append(" ").append("default ").append(currentDefaultValue);
            createSql.append(", ").append(column.name).append("_sysdate_nonnull").append(" ").append(column.definition).append(" ").append("default ").append(currentDefaultValue).append(" not null");
        }
        createSql.append(", primary key(id))");
        this.connection.execute(new String[]{createSql.toString()});
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (1)"});
        TestHelper.enableTableCdc(this.connection, "DV_TEST");
        this.config = ((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.TABLE_INCLUDE_LIST, "db2inst1.dv_test")).build();
        this.start(Db2Connector.class, this.config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("testdb.DB2INST1.DV_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        this.assertNoRecordsToConsume();
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedAddDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedAddDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                AbstractDb2DefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", "0");
                continue;
            }
            if (column.definition.equalsIgnoreCase("TIMESTAMP")) {
                AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
                continue;
            }
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0);
        }
        AbstractDb2DefaultValueIT.waitForStreamingRunning((String)"db2_server", (String)"testdb");
        TestHelper.enableDbCdc(this.connection);
        TestHelper.activeTable(this.connection, "DV_TEST");
        TestHelper.refreshAndWait(this.connection);
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (0)"});
        TestHelper.refreshAndWait(this.connection);
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.recordsForTopic("testdb.DB2INST1.DV_TEST")).hasSize(1);
        this.assertNoRecordsToConsume();
    }

    private void testDefaultValuesAlterTableModifyExisting(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE %table% ");
        for (ColumnDefinition column : columnDefinitions) {
            alterSql.append("ALTER COLUMN ").append(column.name).append(" SET ").append("default ").append(column.modifyDefaultValue);
            alterSql.append(" ALTER COLUMN ").append(column.name).append("_null").append(" SET default null ");
        }
        this.performSchemaChange(this.config, this.connection, alterSql.toString());
        TestHelper.refreshAndWait(this.connection);
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (2)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        records.allRecordsInOrder().forEach(System.out::println);
        this.assertNoRecordsToConsume();
        List tableRecords = records.recordsForTopic("testdb.DB2INST1.DV_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)2);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                AbstractDb2DefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", "0");
                continue;
            }
            if (column.definition.equalsIgnoreCase("TIMESTAMP")) {
                AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
                continue;
            }
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0);
        }
    }

    private void testDefaultValuesAlterTableAdd(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE %table% ");
        for (ColumnDefinition column : columnDefinitions) {
            alterSql.append("ADD COLUMN ").append("a").append(column.name).append(" ").append(column.definition).append(" ").append("default ").append(column.addDefaultValue);
            alterSql.append(" ADD COLUMN ").append("a").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("default null ");
            if (!column.temporalType) continue;
            alterSql.append(" ADD COLUMN ").append("a").append(column.name).append("_sysdate").append(" ").append(column.definition).append(" ").append("default ").append(column.getCurrentRegister());
            alterSql.append(" ADD COLUMN ").append("a").append(column.name).append("_sysdate_nonnull").append(" ").append(column.definition).append(" ").append("default ").append(column.getCurrentRegister()).append(" not null ");
        }
        this.performSchemaChange(this.config, this.connection, alterSql.toString());
        TestHelper.refreshAndWait(this.connection);
        this.connection.execute(new String[]{"INSERT INTO dv_test (id) values (3)"});
        TestHelper.refreshAndWait(this.connection);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("testdb.DB2INST1.DV_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "A" + column.name.toUpperCase(), column.expectedAddDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "A" + column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "A" + column.name.toUpperCase(), column.expectedAddDefaultValue);
                    AbstractDb2DefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "A" + column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE", null);
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, "A" + column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                AbstractDb2DefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", "0");
                AbstractDb2DefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, "A" + column.name.toUpperCase() + "_SYSDATE_NONNULL", "0");
                continue;
            }
            if (column.definition.equalsIgnoreCase("TIMESTAMP")) {
                AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
                AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, "A" + column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
                continue;
            }
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0);
            AbstractDb2DefaultValueIT.assertSchemaFieldWithDefaultCurrentDate(record, "A" + column.name.toUpperCase() + "_SYSDATE_NONNULL", 0);
        }
    }

    private static void assertSchemaFieldWithSameDefaultAndValue(SourceRecord record, String fieldName, Object expectedValue) {
        AbstractDb2DefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(expectedValue));
    }

    private static void assertSchemaFieldNoDefaultWithValue(SourceRecord record, String fieldName, Object fieldValue) {
        AbstractDb2DefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, null, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(fieldValue));
    }

    private static void assertSchemaFieldValueWithDefault(SourceRecord record, String fieldName, Object expectedDefault, Consumer<Object> valueCheck) {
        Struct after = ((Struct)record.value()).getStruct("after");
        Field field = after.schema().field(fieldName);
        ((ObjectAssert)Assertions.assertThat((Object)field).as("Expected non-null field for " + fieldName, new Object[0])).isNotNull();
        Object defaultValue = field.schema().defaultValue();
        if (expectedDefault == null) {
            Assertions.assertThat((Object)defaultValue).isNull();
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Expected non-null default value for field " + fieldName, new Object[0])).isNotNull();
        Assertions.assertThat(defaultValue.getClass()).isEqualTo(expectedDefault.getClass());
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Unexpected default value: " + fieldName + " with field value: " + after.get(fieldName), new Object[0])).isEqualTo(expectedDefault);
        valueCheck.accept(after.get(fieldName));
    }

    private static void assertSchemaFieldWithDefaultCurrentDate(SourceRecord record, String fieldName, Object expectedValue) {
        AbstractDb2DefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, r -> {
            if (expectedValue == null) {
                Assertions.assertThat((Object)r).isNull();
            } else if (expectedValue instanceof Long) {
                ((AbstractLongAssert)Assertions.assertThat((long)((Long)r)).as("Unexpected field value: " + fieldName, new Object[0])).isGreaterThanOrEqualTo(1L);
            } else if (expectedValue instanceof Integer) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)r)).as("Unexpected field value: " + fieldName, new Object[0])).isGreaterThanOrEqualTo(1);
            }
        });
    }

    private static void assertSchemaFieldDefaultAndNonNullValue(SourceRecord record, String fieldName, Object defaultValue) {
        AbstractDb2DefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, defaultValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isNotNull());
    }

    private static class ColumnDefinition {
        public final String name;
        public final String definition;
        public final String addDefaultValue;
        public final String modifyDefaultValue;
        public final Object expectedAddDefaultValue;
        public final Object expectedModifyDefaultValue;
        public final AssertionType assertionType;
        public final boolean temporalType;

        public ColumnDefinition(String name, String definition, String addDefaultValue, String modifyDefaultValue, Object expectedAddDefaultValue, Object expectedModifyDefaultValue, AssertionType assertionType) {
            this.name = name;
            this.definition = definition;
            this.addDefaultValue = addDefaultValue;
            this.modifyDefaultValue = modifyDefaultValue;
            this.expectedAddDefaultValue = expectedAddDefaultValue;
            this.expectedModifyDefaultValue = expectedModifyDefaultValue;
            this.assertionType = assertionType;
            this.temporalType = definition.equalsIgnoreCase("date") || definition.toUpperCase().startsWith("TIMESTAMP") || definition.equalsIgnoreCase("TIME");
        }

        public String getCurrentRegister() {
            if (this.definition.equalsIgnoreCase("DATE")) {
                return "CURRENT DATE";
            }
            if (this.definition.equalsIgnoreCase("TIMESTAMP")) {
                return "CURRENT TIMESTAMP";
            }
            if (this.definition.equalsIgnoreCase("TIME")) {
                return "CURRENT TIME";
            }
            throw new RuntimeException("Unexpected temporal type for current time register: " + this.definition);
        }
    }

    static enum AssertionType {
        FIELD_DEFAULT_EQUAL,
        FIELD_NO_DEFAULT;

    }
}

