/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2SourceInfoStructMaker;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.Module;
import io.debezium.document.Document;
import io.debezium.heartbeat.DatabaseHeartbeatImpl;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class Db2ConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_PORT = 50000;
    public static final Field PORT = RelationalDatabaseConnectorConfig.PORT.withDefault(50000);
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(new Field.Validator[]{CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName});
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.REPEATABLE_READ).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. In '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' mode no table locks or any *long-lasting* row-level locks are acquired, but connector does not guarantee snapshot consistency.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    private static final ConfigDefinition CONFIG_DEFINITION = HistorizedRelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().name("Db2").type(new Field[]{HOSTNAME, PORT, USER, PASSWORD, DATABASE_NAME}).connector(new Field[]{SNAPSHOT_MODE, INCREMENTAL_SNAPSHOT_CHUNK_SIZE, SCHEMA_NAME_ADJUSTMENT_MODE}).excluding(new Field[]{SCHEMA_WHITELIST, SCHEMA_INCLUDE_LIST, SCHEMA_BLACKLIST, SCHEMA_EXCLUDE_LIST, BINARY_HANDLING_MODE, INCLUDE_SCHEMA_COMMENTS, INCREMENTAL_SNAPSHOT_ALLOW_SCHEMA_CHANGES, SNAPSHOT_MAX_THREADS, DatabaseHeartbeatImpl.HEARTBEAT_ACTION_QUERY}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final String databaseName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public Db2ConnectorConfig(Configuration config) {
        super(Db2Connector.class, config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), false, ColumnFilterMode.SCHEMA, false);
        this.databaseName = config.getString(DATABASE_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new Db2SourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString((CharSequence)"change_lsn")).compareTo(Lsn.valueOf(desired.getString((CharSequence)"change_lsn"))) < 1;
            }
        };
    }

    public String getContextName() {
        return Module.contextName();
    }

    public Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse((String)table, (boolean)false), this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return t.schema() != null && !t.table().toLowerCase().startsWith("ibmsnap_") && !t.schema().toUpperCase().startsWith("ASNCDC") && !t.schema().toUpperCase().startsWith("SYSTOOLS") && !t.table().toLowerCase().startsWith("ibmqrep_");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true, true),
        INITIAL_ONLY("initial_only", true, false),
        SCHEMA_ONLY("schema_only", false, true);

        private final String value;
        private final boolean includeData;
        private final boolean shouldStream;

        private SnapshotMode(String value, boolean includeData, boolean shouldStream) {
            this.value = value;
            this.includeData = includeData;
            this.shouldStream = shouldStream;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public boolean shouldStream() {
            return this.shouldStream;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

