/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TransactionMetadataIT
extends AbstractConnectorTest {
    private Db2Connection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int not null, cola varchar(30), primary key (id))", "CREATE TABLE tableb (id int not null, colb varchar(30), primary key (id))", "INSERT INTO tablea VALUES(1, 'a')"});
        TestHelper.enableTableCdc(this.connection, "TABLEA");
        TestHelper.enableTableCdc(this.connection, "TABLEB");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
        Testing.Print.enable();
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "TABLEB");
            TestHelper.disableTableCdc(this.connection, "TABLEA");
            this.connection.execute(new String[]{"DROP TABLE tablea", "DROP TABLE tableb"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    @Test
    public void transactionMetadata() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int ID_START = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).build();
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        this.consumeRecordsByTopic(1);
        TestHelper.enableDbCdc(this.connection);
        this.connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER = 'DB2INST1'"});
        TestHelper.refreshAndWait(this.connection);
        this.connection.setAutoCommit(false);
        String[] inserts = new String[10];
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            inserts[2 * i] = "INSERT INTO tablea VALUES(" + id + ", 'a')";
            inserts[2 * i + 1] = "INSERT INTO tableb VALUES(" + id + ", 'b')";
        }
        this.connection.execute(inserts);
        this.connection.setAutoCommit(true);
        this.connection.execute(new String[]{"INSERT INTO tableb VALUES(1000, 'b')"});
        TestHelper.refreshAndWait(this.connection);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(14);
        List tableA = records.recordsForTopic("testdb.DB2INST1.TABLEA");
        List tableB = records.recordsForTopic("testdb.DB2INST1.TABLEB");
        List tx = records.recordsForTopic("testdb.transaction");
        Assertions.assertThat((List)tableA).hasSize(5);
        Assertions.assertThat((List)tableB).hasSize(6);
        Assertions.assertThat((List)tx).hasSize(3);
        List all = records.allRecordsInOrder();
        String txId = this.assertBeginTransaction((SourceRecord)all.get(0));
        long counter = 1L;
        for (int i = 1; i <= 10; ++i) {
            this.assertRecordTransactionMetadata((SourceRecord)all.get(i), txId, counter, (counter + 1L) / 2L);
            ++counter;
        }
        this.assertEndTransaction((SourceRecord)all.get(11), txId, 10L, Collect.hashMapOf((Object)"DB2INST1.TABLEA", (Object)5, (Object)"DB2INST1.TABLEB", (Object)5));
        this.stopConnector();
    }
}

