/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;

public abstract class AbstractChangeRecordEmitter<T extends DataCollectionSchema>
implements ChangeRecordEmitter {
    private final Partition partition;
    private final OffsetContext offsetContext;
    private final Clock clock;

    public AbstractChangeRecordEmitter(Partition partition, OffsetContext offsetContext, Clock clock) {
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.clock = clock;
    }

    @Override
    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver receiver) throws InterruptedException {
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, schema);
                break;
            }
            case READ: {
                this.emitReadRecord(receiver, schema);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, schema);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, schema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public OffsetContext getOffset() {
        return this.offsetContext;
    }

    public Clock getClock() {
        return this.clock;
    }

    protected abstract void emitReadRecord(ChangeRecordEmitter.Receiver var1, T var2) throws InterruptedException;

    protected abstract void emitCreateRecord(ChangeRecordEmitter.Receiver var1, T var2) throws InterruptedException;

    protected abstract void emitUpdateRecord(ChangeRecordEmitter.Receiver var1, T var2) throws InterruptedException;

    protected abstract void emitDeleteRecord(ChangeRecordEmitter.Receiver var1, T var2) throws InterruptedException;
}

