/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2.util;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.history.FileDatabaseHistory;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Testing;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Objects;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    public static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-connect.txt").toAbsolutePath();
    public static final String TEST_DATABASE = "testdb";
    public static final int WAIT_FOR_CDC = 3000;
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final String STATEMENTS_TABLE_PLACEHOLDER = "#";
    private static final String STATEMENTS_SCHEMA_PLACEHOLDER = "@";
    private static final String ENABLE_DB_CDC = "VALUES ASNCDC.ASNCDCSERVICES('start','asncdc')";
    private static final String DISABLE_DB_CDC = "VALUES ASNCDC.ASNCDCSERVICES('stop','asncdc')";
    private static final String STATUS_DB_CDC = "VALUES ASNCDC.ASNCDCSERVICES('status','asncdc')";
    private static final String ENABLE_TABLE_CDC = "CALL ASNCDC.ADDTABLE('@', '#' )";
    private static final String DISABLE_TABLE_CDC = "CALL ASNCDC.REMOVETABLE('@', '#' )";
    private static final String RESTART_ASN_CDC = "VALUES ASNCDC.ASNCDCSERVICES('reinit','asncdc')";

    public static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 50000)).withDefault(JdbcConfiguration.USER, "db2inst1")).withDefault(JdbcConfiguration.PASSWORD, "admin")).build();
    }

    public static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.")).withDefault(JdbcConfiguration.DATABASE, TEST_DATABASE)).withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 50000)).withDefault(JdbcConfiguration.USER, "db2inst1")).withDefault(JdbcConfiguration.PASSWORD, "admin")).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with("database." + field, value));
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(Db2ConnectorConfig.SERVER_NAME, TEST_DATABASE)).with(Db2ConnectorConfig.DATABASE_HISTORY, FileDatabaseHistory.class)).with(FileDatabaseHistory.FILE_PATH, (Object)DB_HISTORY_PATH)).with(Db2ConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    public static Db2Connection adminConnection() {
        return new Db2Connection((Configuration)TestHelper.adminJdbcConfig());
    }

    public static Db2Connection testConnection() {
        return new Db2Connection((Configuration)TestHelper.defaultJdbcConfig());
    }

    public static void enableDbCdc(Db2Connection connection) throws SQLException {
        connection.execute(new String[]{ENABLE_DB_CDC});
        Statement stmt = connection.connection().createStatement();
        boolean isNotrunning = true;
        int count = 0;
        while (isNotrunning) {
            ResultSet rs = stmt.executeQuery(STATUS_DB_CDC);
            while (rs.next()) {
                Clob clob = rs.getClob(1);
                String test = clob.getSubString(1L, (int)clob.length());
                if (test.contains("is doing work")) {
                    isNotrunning = false;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (count++ <= 30) continue;
                throw new SQLException("ASNCAP server did not start.");
            }
        }
    }

    public static void disableDbCdc(Db2Connection connection) throws SQLException {
        connection.execute(new String[]{DISABLE_DB_CDC});
    }

    public static void enableTableCdc(Db2Connection connection, String name) throws SQLException {
        TestHelper.enableTableCdc(connection, "DB2INST1", name);
    }

    public static void enableTableCdc(Db2Connection connection, String schemaName, String tableName) throws SQLException {
        Objects.requireNonNull(schemaName);
        Objects.requireNonNull(tableName);
        String enableCdcForTableStmt = ENABLE_TABLE_CDC.replace(STATEMENTS_SCHEMA_PLACEHOLDER, schemaName).replace(STATEMENTS_TABLE_PLACEHOLDER, tableName);
        connection.execute(new String[]{enableCdcForTableStmt});
        connection.execute(new String[]{"UPDATE ASNCDC.IBMSNAP_REGISTER SET STATE = 'A' WHERE SOURCE_OWNER  = '" + schemaName + "' AND SOURCE_TABLE = '" + tableName + "'"});
        connection.execute(new String[]{RESTART_ASN_CDC});
    }

    public static void disableTableCdc(Db2Connection connection, String name) throws SQLException {
        TestHelper.disableTableCdc(connection, "DB2INST1", name);
    }

    public static void disableTableCdc(Db2Connection connection, String schemaName, String tableName) throws SQLException {
        Objects.requireNonNull(schemaName);
        Objects.requireNonNull(tableName);
        String disableCdcForTableStmt = DISABLE_TABLE_CDC.replace(STATEMENTS_SCHEMA_PLACEHOLDER, schemaName).replace(STATEMENTS_TABLE_PLACEHOLDER, tableName);
        connection.execute(new String[]{disableCdcForTableStmt});
        connection.execute(new String[]{RESTART_ASN_CDC});
    }

    public static void waitForSnapshotToBeCompleted() throws InterruptedException {
        int waitForSeconds = 60;
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Metronome metronome = Metronome.sleeper((Duration)Duration.ofSeconds(1L), (Clock)Clock.system());
        while (true) {
            if (waitForSeconds-- <= 0) {
                Assert.fail((String)"Snapshot was not completed on time");
            }
            try {
                boolean completed = (Boolean)mbeanServer.getAttribute(new ObjectName("debezium.db2_server:type=connector-metrics,context=snapshot,server=testdb"), "SnapshotCompleted");
                if (completed) {
                    break;
                }
            }
            catch (InstanceNotFoundException completed) {
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            metronome.pause();
        }
    }

    public static void refreshAndWait(Db2Connection connection) throws SQLException {
        connection.execute(new String[]{RESTART_ASN_CDC});
        TestHelper.waitForCDC();
    }

    public static void waitForCDC() {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

