/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.TableId;
import io.debezium.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class IncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalSnapshotContext.class);
    public static final String INCREMENTAL_SNAPSHOT_KEY = "incremental_snapshot";
    public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY = "incremental_snapshot_collections";
    public static final String EVENT_PRIMARY_KEY = "incremental_snapshot_primary_key";
    public static final String TABLE_MAXIMUM_KEY = "incremental_snapshot_maximum_key";
    private boolean windowOpened = false;
    private Object[] chunkEndPosition;
    private final Queue<T> dataCollectionsToSnapshot = new LinkedList<T>();
    private Object[] lastEventKeySent;
    private String currentChunkId;
    private Object[] maximumKey;

    public boolean openWindow(String id) {
        if (!id.startsWith(this.currentChunkId)) {
            LOGGER.info("Arrived request to open window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Opening window for incremental snapshot chunk");
        this.windowOpened = true;
        return true;
    }

    public boolean closeWindow(String id) {
        if (!id.startsWith(this.currentChunkId)) {
            LOGGER.info("Arrived request to close window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Closing window for incremental snapshot chunk");
        this.windowOpened = false;
        return true;
    }

    public boolean deduplicationNeeded() {
        return this.windowOpened;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String arrayToSerializedString(Object[] array) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(array);
                string = HexConverter.convertToHexString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize chunk information %s", array));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object[] serializedStringToArray(String field, String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex(serialized));){
            Object[] objectArray;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                objectArray = (Object[])ois.readObject();
            }
            return objectArray;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize '%s' with value '%s'", field, serialized), (Throwable)e);
        }
    }

    private String dataCollectionsToSnapshotAsString() {
        return this.dataCollectionsToSnapshot.stream().map(x -> x.toString()).collect(Collectors.joining(","));
    }

    private List<String> stringToDataCollections(String dataCollectionsStr) {
        return Arrays.asList(dataCollectionsStr.split(","));
    }

    protected boolean snapshotRunning() {
        return !this.dataCollectionsToSnapshot.isEmpty();
    }

    public Map<String, Object> store(Map<String, Object> offset) {
        if (!this.snapshotRunning()) {
            return offset;
        }
        offset.put(EVENT_PRIMARY_KEY, this.arrayToSerializedString(this.lastEventKeySent));
        offset.put(TABLE_MAXIMUM_KEY, this.arrayToSerializedString(this.maximumKey));
        offset.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY, this.dataCollectionsToSnapshotAsString());
        return offset;
    }

    private void addTablesIdsToSnapshot(List<T> dataCollectionIds) {
        this.dataCollectionsToSnapshot.addAll(dataCollectionIds);
    }

    public List<T> addDataCollectionNamesToSnapshot(List<String> dataCollectionIds) {
        List newDataCollectionIds = dataCollectionIds.stream().map(x -> TableId.parse(x)).collect(Collectors.toList());
        this.addTablesIdsToSnapshot(newDataCollectionIds);
        return newDataCollectionIds;
    }

    public static <U> IncrementalSnapshotContext<U> load(Map<String, ?> offsets, Class<U> clazz) {
        IncrementalSnapshotContext context = new IncrementalSnapshotContext();
        String lastEventSentKeyStr = (String)offsets.get(EVENT_PRIMARY_KEY);
        context.chunkEndPosition = lastEventSentKeyStr != null ? super.serializedStringToArray(EVENT_PRIMARY_KEY, lastEventSentKeyStr) : null;
        context.lastEventKeySent = null;
        String maximumKeyStr = (String)offsets.get(TABLE_MAXIMUM_KEY);
        context.maximumKey = maximumKeyStr != null ? super.serializedStringToArray(TABLE_MAXIMUM_KEY, maximumKeyStr) : null;
        String dataCollectionsStr = (String)offsets.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY);
        context.dataCollectionsToSnapshot.clear();
        if (dataCollectionsStr != null) {
            context.addDataCollectionNamesToSnapshot(super.stringToDataCollections(dataCollectionsStr));
        }
        return context;
    }

    public void sendEvent(Object[] key) {
        this.lastEventKeySent = key;
    }

    public T currentDataCollectionId() {
        return this.dataCollectionsToSnapshot.peek();
    }

    public int tablesToBeSnapshottedCount() {
        return this.dataCollectionsToSnapshot.size();
    }

    public void nextChunkPosition(Object[] end) {
        this.chunkEndPosition = end;
    }

    public Object[] chunkEndPosititon() {
        return this.chunkEndPosition;
    }

    private void resetChunk() {
        this.chunkEndPosition = null;
        this.maximumKey = null;
    }

    public boolean isNonInitialChunk() {
        return this.chunkEndPosition != null;
    }

    public T nextDataCollection() {
        this.resetChunk();
        return this.dataCollectionsToSnapshot.poll();
    }

    public void startNewChunk() {
        this.currentChunkId = UUID.randomUUID().toString();
        LOGGER.debug("Starting new chunk with id '{}'", (Object)this.currentChunkId);
    }

    public String currentChunkId() {
        return this.currentChunkId;
    }

    public void maximumKey(Object[] key) {
        this.maximumKey = key;
    }

    public Optional<Object[]> maximumKey() {
        return Optional.ofNullable(this.maximumKey);
    }

    public String toString() {
        return "IncrementalSnapshotContext [windowOpened=" + this.windowOpened + ", chunkEndPosition=" + Arrays.toString(this.chunkEndPosition) + ", dataCollectionsToSnapshot=" + this.dataCollectionsToSnapshot + ", lastEventKeySent=" + Arrays.toString(this.lastEventKeySent) + ", maximumKey=" + Arrays.toString(this.maximumKey) + "]";
    }
}

