/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SchemaHistoryTopicIT
extends AbstractConnectorTest {
    private Db2Connection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
        this.connection.execute(new String[]{"CREATE TABLE tablea (id int not null, cola varchar(30), primary key(id))", "CREATE TABLE tableb (id int not null, colb varchar(30), primary key(id))", "CREATE TABLE tablec (id int not null, colc varchar(30), primary key(id))"});
        TestHelper.enableTableCdc(this.connection, "TABLEA");
        TestHelper.enableTableCdc(this.connection, "TABLEB");
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.DB_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        if (this.connection != null) {
            TestHelper.disableDbCdc(this.connection);
            TestHelper.disableTableCdc(this.connection, "TABLEB");
            TestHelper.disableTableCdc(this.connection, "TABLEA");
            this.connection.execute(new String[]{"DROP TABLE tablea", "DROP TABLE tableb", "DROP TABLE tablec"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMSNAP_REGISTER"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_COLVERSION"});
            this.connection.execute(new String[]{"DELETE FROM ASNCDC.IBMQREP_TABVERSION"});
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-1904"})
    public void snapshotSchemaChanges() throws Exception {
        int RECORDS_PER_TABLE = 5;
        int TABLES = 2;
        int ID_START_1 = 10;
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(Db2ConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)Db2ConnectorConfig.SnapshotMode.INITIAL)).with(Db2ConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).build();
        for (int i = 0; i < 5; ++i) {
            int id = 10 + i;
            this.connection.execute(new String[]{"INSERT INTO tablea VALUES(" + id + ", 'a')"});
            this.connection.execute(new String[]{"INSERT INTO tableb VALUES(" + id + ", 'b')"});
        }
        this.start(Db2Connector.class, config);
        this.assertConnectorIsRunning();
        TestHelper.waitForSnapshotToBeCompleted();
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(3);
        List schemaRecords = records.allRecordsInOrder();
        Assertions.assertThat((List)schemaRecords).hasSize(3);
        schemaRecords.forEach(record -> {
            Assertions.assertThat((String)record.topic()).isEqualTo((Object)"testdb");
            Assertions.assertThat((String)((Struct)record.key()).getString("databaseName")).isEqualTo((Object)"TESTDB");
            Assertions.assertThat(record.sourceOffset().get("snapshot")).isEqualTo((Object)true);
        });
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(0)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(1)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        Assertions.assertThat((String)((Struct)((SourceRecord)schemaRecords.get(2)).value()).getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        List tableChanges = ((Struct)((SourceRecord)schemaRecords.get(0)).value()).getArray("tableChanges");
        Assertions.assertThat((List)tableChanges).hasSize(1);
        Assertions.assertThat((Object)((Struct)tableChanges.get(0)).get("type")).isEqualTo((Object)"CREATE");
        records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((List)records.recordsForTopic("testdb.DB2INST1.TABLEA")).hasSize(5);
        Assertions.assertThat((List)records.recordsForTopic("testdb.DB2INST1.TABLEB")).hasSize(5);
        records.recordsForTopic("testdb.DB2INST1.TABLEB").forEach(record -> this.assertSchemaMatchesStruct((Struct)((Struct)record.value()).get("after"), SchemaBuilder.struct().optional().name("testdb.DB2INST1.TABLEB.Value").field("ID", Schema.INT32_SCHEMA).field("COLB", Schema.OPTIONAL_STRING_SCHEMA).build()));
    }
}

