/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import com.ibm.db2.jcc.DB2Driver;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.db2.Db2ChangeTable;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2ObjectNameQuoter;
import io.debezium.connector.db2.Lsn;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.BoundedConcurrentHashMap;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2Connection
extends JdbcConnection {
    private static final String GET_DATABASE_NAME = "SELECT CURRENT SERVER FROM SYSIBM.SYSDUMMY1";
    private static Logger LOGGER = LoggerFactory.getLogger(Db2Connection.class);
    private static final String CDC_SCHEMA = "ASNCDC";
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String GET_MAX_LSN = "SELECT max(t.SYNCHPOINT) FROM ( SELECT CD_NEW_SYNCHPOINT AS SYNCHPOINT FROM ASNCDC.IBMSNAP_REGISTER UNION ALL SELECT SYNCHPOINT AS SYNCHPOINT FROM ASNCDC.IBMSNAP_REGISTER) t";
    private static final String LOCK_TABLE = "SELECT * FROM # WITH CS";
    private static final String LSN_TO_TIMESTAMP = "SELECT CURRENT TIMEstamp FROM sysibm.sysdummy1  WHERE ? > X'00000000000000000000000000000000'";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "SELECT CASE WHEN IBMSNAP_OPERATION = 'D' AND (LEAD(cdc.IBMSNAP_OPERATION,1,'X') OVER (PARTITION BY cdc.IBMSNAP_COMMITSEQ ORDER BY cdc.IBMSNAP_INTENTSEQ)) ='I' THEN 3 WHEN IBMSNAP_OPERATION = 'I' AND (LAG(cdc.IBMSNAP_OPERATION,1,'X') OVER (PARTITION BY cdc.IBMSNAP_COMMITSEQ ORDER BY cdc.IBMSNAP_INTENTSEQ)) ='D' THEN 4 WHEN IBMSNAP_OPERATION = 'D' THEN 1 WHEN IBMSNAP_OPERATION = 'I' THEN 2 END OPCODE,cdc.* FROM ASNCDC.# cdc WHERE   IBMSNAP_COMMITSEQ >= ? AND IBMSNAP_COMMITSEQ <= ? order by IBMSNAP_COMMITSEQ, IBMSNAP_INTENTSEQ";
    private static final String GET_LIST_OF_CDC_ENABLED_TABLES = "select r.SOURCE_OWNER, r.SOURCE_TABLE, r.CD_OWNER, r.CD_TABLE, r.CD_NEW_SYNCHPOINT, r.CD_OLD_SYNCHPOINT, t.TBSPACEID, t.TABLEID , CAST((t.TBSPACEID * 65536 +  t.TABLEID )AS INTEGER )from ASNCDC.IBMSNAP_REGISTER r left JOIN SYSCAT.TABLES t ON r.SOURCE_OWNER  = t.TABSCHEMA AND r.SOURCE_TABLE = t.TABNAME  WHERE r.SOURCE_OWNER <> ''";
    private static final String GET_LIST_OF_NEW_CDC_ENABLED_TABLES = "select CAST((t.TBSPACEID * 65536 +  t.TABLEID )AS INTEGER ) AS OBJECTID,        CD_OWNER CONCAT '.' CONCAT CD_TABLE,        CD_NEW_SYNCHPOINT,        CD_OLD_SYNCHPOINT from ASNCDC.IBMSNAP_REGISTER  r left JOIN SYSCAT.TABLES t ON r.SOURCE_OWNER  = t.TABSCHEMA AND r.SOURCE_TABLE = t.TABNAME WHERE r.SOURCE_OWNER <> '' AND 1=0 AND CD_NEW_SYNCHPOINT > ? AND CD_OLD_SYNCHPOINT < ? ";
    private static final String GET_LIST_OF_KEY_COLUMNS = "SELECT CAST((t.TBSPACEID * 65536 +  t.TABLEID )AS INTEGER ) as objectid, c.colname,c.colno,c.keyseq FROM syscat.tables  as t inner join syscat.columns as c  on t.tabname = c.tabname and t.tabschema = c.tabschema and c.KEYSEQ > 0 AND t.tbspaceid = CAST(BITAND( ? , 4294901760) / 65536 AS SMALLINT) AND t.tableid=  CAST(BITAND( ? , 65535) AS SMALLINT)";
    private static final int CHANGE_TABLE_DATA_COLUMN_OFFSET = 4;
    private static final String URL_PATTERN = "jdbc:db2://${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
    private static final JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)URL_PATTERN, (String)DB2Driver.class.getName(), (ClassLoader)Db2Connection.class.getClassLoader(), (Field[])new Field[]{JdbcConfiguration.PORT.withDefault(Db2ConnectorConfig.PORT.defaultValueAsString())});
    private final String realDatabaseName;
    private final BoundedConcurrentHashMap<Lsn, Instant> lsnToInstantCache = new BoundedConcurrentHashMap(100);

    public Db2Connection(Configuration config) {
        super(config, FACTORY);
        this.realDatabaseName = this.retrieveRealDatabaseName();
    }

    public Lsn getMaxLsn() throws SQLException {
        return (Lsn)this.queryAndMap(GET_MAX_LSN, this.singleResultMapper(rs -> {
            Lsn ret = Lsn.valueOf(rs.getBytes(1));
            LOGGER.trace("Current maximum lsn is {}", (Object)ret);
            return ret;
        }, "Maximum LSN query must return exactly one value"));
    }

    public void getChangesForTable(TableId tableId, Lsn fromLsn, Lsn toLsn, JdbcConnection.ResultSetConsumer consumer) throws SQLException {
        String query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, this.cdcNameForTable(tableId));
        this.prepareQuery(query, statement -> {
            statement.setBytes(1, fromLsn.getBinary());
            statement.setBytes(2, toLsn.getBinary());
        }, consumer);
    }

    public void getChangesForTables(Db2ChangeTable[] changeTables, Lsn intervalFromLsn, Lsn intervalToLsn, JdbcConnection.BlockingMultiResultSetConsumer consumer) throws SQLException, InterruptedException {
        String[] queries = new String[changeTables.length];
        JdbcConnection.StatementPreparer[] preparers = new JdbcConnection.StatementPreparer[changeTables.length];
        int idx = 0;
        for (Db2ChangeTable changeTable : changeTables) {
            String query;
            queries[idx] = query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            LOGGER.trace("Getting changes for table {} in range[{}, {}]", new Object[]{changeTable, intervalFromLsn, intervalToLsn});
            preparers[idx] = statement -> {
                statement.setBytes(1, intervalFromLsn.getBinary());
                statement.setBytes(2, intervalToLsn.getBinary());
            };
            ++idx;
        }
        this.prepareQuery(queries, preparers, consumer);
    }

    public Lsn incrementLsn(Lsn lsn) throws SQLException {
        return lsn.increment();
    }

    public Instant timestampOfLsn(Lsn lsn) throws SQLException {
        String query = LSN_TO_TIMESTAMP;
        if (lsn.getBinary() == null) {
            return null;
        }
        Instant cachedInstant = (Instant)this.lsnToInstantCache.get((Object)lsn);
        if (cachedInstant != null) {
            return cachedInstant;
        }
        return (Instant)this.prepareQueryAndMap(LSN_TO_TIMESTAMP, statement -> statement.setBytes(1, lsn.getBinary()), this.singleResultMapper(rs -> {
            Timestamp ts = rs.getTimestamp(1);
            Instant ret = ts == null ? null : ts.toInstant();
            LOGGER.trace("Timestamp of lsn {} is {}", (Object)lsn, (Object)ret);
            if (ret != null) {
                this.lsnToInstantCache.put((Object)lsn, (Object)ret);
            }
            return ret;
        }, "LSN to timestamp query must return exactly one value"));
    }

    public void lockTable(TableId tableId) throws SQLException {
        String lockTableStmt = LOCK_TABLE.replace(STATEMENTS_PLACEHOLDER, tableId.table());
        this.execute(new String[]{lockTableStmt});
    }

    private String cdcNameForTable(TableId tableId) {
        return Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema() + '_' + tableId.table());
    }

    public Set<Db2ChangeTable> listOfChangeTables() throws SQLException {
        String query = GET_LIST_OF_CDC_ENABLED_TABLES;
        return (Set)this.queryAndMap(GET_LIST_OF_CDC_ENABLED_TABLES, rs -> {
            HashSet<Db2ChangeTable> changeTables = new HashSet<Db2ChangeTable>();
            while (rs.next()) {
                changeTables.add(new Db2ChangeTable(new TableId("", rs.getString(1), rs.getString(2)), rs.getString(4), rs.getInt(9), Lsn.valueOf(rs.getBytes(5)), Lsn.valueOf(rs.getBytes(6))));
            }
            return changeTables;
        });
    }

    public Set<Db2ChangeTable> listOfNewChangeTables(Lsn fromLsn, Lsn toLsn) throws SQLException {
        String query = GET_LIST_OF_NEW_CDC_ENABLED_TABLES;
        return (Set)this.prepareQueryAndMap(GET_LIST_OF_NEW_CDC_ENABLED_TABLES, ps -> {
            ps.setBytes(1, fromLsn.getBinary());
            ps.setBytes(2, toLsn.getBinary());
        }, rs -> {
            HashSet<Db2ChangeTable> changeTables = new HashSet<Db2ChangeTable>();
            while (rs.next()) {
                changeTables.add(new Db2ChangeTable(rs.getString(2), rs.getInt(1), Lsn.valueOf(rs.getBytes(3)), Lsn.valueOf(rs.getBytes(4))));
            }
            return changeTables;
        });
    }

    public Table getTableSchemaFromTable(Db2ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        ArrayList columns = new ArrayList();
        try (ResultSet rs = metadata.getColumns(null, changeTable.getSourceTableId().schema(), changeTable.getSourceTableId().table(), null);){
            while (rs.next()) {
                this.readTableColumn(rs, changeTable.getSourceTableId(), null).ifPresent(ce -> columns.add(ce.create()));
            }
        }
        List pkColumnNames = this.readPrimaryKeyNames(metadata, changeTable.getSourceTableId());
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public Table getTableSchemaFromChangeTable(Db2ChangeTable changeTable) throws SQLException {
        DatabaseMetaData metadata = this.connection().getMetaData();
        TableId changeTableId = changeTable.getChangeTableId();
        ArrayList columnEditors = new ArrayList();
        try (ResultSet rs2 = metadata.getColumns(null, changeTableId.schema(), changeTableId.table(), null);){
            while (rs2.next()) {
                this.readTableColumn(rs2, changeTableId, null).ifPresent(columnEditors::add);
            }
        }
        List columns = columnEditors.subList(4, columnEditors.size()).stream().map(c -> c.position(c.position() - 4).create()).collect(Collectors.toList());
        ArrayList pkColumnNames = new ArrayList();
        this.prepareQuery(GET_LIST_OF_KEY_COLUMNS, ps -> {
            ps.setInt(1, changeTable.getChangeTableObjectId());
            ps.setInt(1, changeTable.getChangeTableObjectId());
        }, rs -> {
            while (rs.next()) {
                pkColumnNames.add(rs.getString(2));
            }
        });
        Collections.sort(columns);
        return Table.editor().tableId(changeTable.getSourceTableId()).addColumns(columns).setPrimaryKeyNames(pkColumnNames).create();
    }

    public String getNameOfChangeTable(String captureName) {
        return captureName + "_CT";
    }

    public String getRealDatabaseName() {
        return this.realDatabaseName;
    }

    private String retrieveRealDatabaseName() {
        try {
            return (String)this.queryAndMap(GET_DATABASE_NAME, this.singleResultMapper(rs -> rs.getString(1), "Could not retrieve database name"));
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't obtain database name", e);
        }
    }

    public static class CdcEnabledTable {
        private final String tableId;
        private final String captureName;
        private final Lsn fromLsn;

        private CdcEnabledTable(String tableId, String captureName, Lsn fromLsn) {
            this.tableId = tableId;
            this.captureName = captureName;
            this.fromLsn = fromLsn;
        }

        public String getTableId() {
            return this.tableId;
        }

        public String getCaptureName() {
            return this.captureName;
        }

        public Lsn getFromLsn() {
            return this.fromLsn;
        }
    }

    private static interface ResultSetExtractor<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

