/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2SourceInfoStructMaker;
import io.debezium.connector.db2.Lsn;
import io.debezium.connector.db2.Module;
import io.debezium.document.Document;
import io.debezium.function.Predicates;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnId;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

public class Db2ConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_PORT = 50000;
    public static final Field HOSTNAME = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Db2 database server.");
    public static final Field PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(50000).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Db2 database server.");
    public static final Field USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the Db2 database user to be used when connecting to the database.");
    public static final Field PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the Db2 database user to be used when connecting to the database.");
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(new Field.Validator[]{CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName});
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring.");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field SNAPSHOT_ISOLATION_MODE = Field.create((String)"snapshot.isolation.mode").withDisplayName("Snapshot isolation mode").withEnum(SnapshotIsolationMode.class, (Enum)SnapshotIsolationMode.REPEATABLE_READ).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls which transaction isolation level is used and how long the connector locks the monitored tables. The default is '" + SnapshotIsolationMode.REPEATABLE_READ.getValue() + "', which means that repeatable read isolation level is used. In addition, exclusive locks are taken only during schema snapshot. Using a value of '" + SnapshotIsolationMode.EXCLUSIVE.getValue() + "' ensures that the connector holds the exclusive lock (and thus prevents any reads and updates) for all monitored tables during the entire snapshot duration. In '" + SnapshotIsolationMode.READ_COMMITTED.getValue() + "' mode no table locks or any *long-lasting* row-level locks are acquired, but connector does not guarantee snapshot consistency.In '" + SnapshotIsolationMode.READ_UNCOMMITTED.getValue() + "' mode neither table nor row-level locks are acquired, but connector does not guarantee snapshot consistency.");
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, DATABASE_NAME, SNAPSHOT_MODE, RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY, RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST, RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.DECIMAL_HANDLING_MODE, RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE});
    private final String databaseName;
    private final SnapshotMode snapshotMode;
    private final SnapshotIsolationMode snapshotIsolationMode;
    private final Tables.ColumnNameFilter columnFilter;

    public static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"DB2 Server", (Field[])new Field[]{HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, DATABASE_NAME, SNAPSHOT_MODE});
        Field.group((ConfigDef)config, (String)"History Storage", (Field[])new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST, RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, RelationalDatabaseConnectorConfig.DECIMAL_HANDLING_MODE, RelationalDatabaseConnectorConfig.TIME_PRECISION_MODE});
        return config;
    }

    public Db2ConnectorConfig(Configuration config) {
        super(Db2Connector.class, config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), false);
        this.databaseName = config.getString(DATABASE_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE), SNAPSHOT_MODE.defaultValueAsString());
        this.snapshotIsolationMode = SnapshotIsolationMode.parse(config.getString(SNAPSHOT_ISOLATION_MODE), SNAPSHOT_ISOLATION_MODE.defaultValueAsString());
        this.columnFilter = Db2ConnectorConfig.getColumnNameFilter(config.getFallbackStringProperty(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST));
    }

    private static Tables.ColumnNameFilter getColumnNameFilter(final String excludedColumnPatterns) {
        return new Tables.ColumnNameFilter(){
            Predicate<ColumnId> delegate;
            {
                this.delegate = Predicates.excludes((String)excludedColumnPatterns, ColumnId::toString);
            }

            public boolean matches(String catalogName, String schemaName, String tableName, String columnName) {
                return this.delegate.test(new ColumnId(new TableId(null, schemaName, tableName), columnName));
            }
        };
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public SnapshotIsolationMode getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public Tables.ColumnNameFilter getColumnFilter() {
        return this.columnFilter;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new Db2SourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return Lsn.valueOf(recorded.getString((CharSequence)"change_lsn")).compareTo(Lsn.valueOf(desired.getString((CharSequence)"change_lsn"))) < 1;
            }
        };
    }

    public String getContextName() {
        return Module.contextName();
    }

    public Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse((String)table, (boolean)false), this.getConfig().getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return Collections.unmodifiableMap(snapshotSelectOverridesByTable);
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return !t.table().toLowerCase().startsWith("ibmsnap_") && !t.schema().toUpperCase().startsWith("ASNCDC") && !t.schema().toUpperCase().startsWith("SYSTOOLS") && !t.table().toLowerCase().startsWith("ibmqrep_");
        }
    }

    public static enum SnapshotIsolationMode implements EnumeratedValue
    {
        EXCLUSIVE("exclusive"),
        REPEATABLE_READ("repeatable_read"),
        READ_COMMITTED("read_committed"),
        READ_UNCOMMITTED("read_uncommitted");

        private final String value;

        private SnapshotIsolationMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotIsolationMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotIsolationMode option : SnapshotIsolationMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotIsolationMode parse(String value, String defaultValue) {
            SnapshotIsolationMode mode = SnapshotIsolationMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotIsolationMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

