/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.db2.Db2ChangeEventSourceFactory;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2EventMetadataProvider;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2TaskContext;
import io.debezium.connector.db2.Db2TopicSelector;
import io.debezium.connector.db2.Module;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ConnectorTask
extends BaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2ConnectorTask.class);
    private static final String CONTEXT_NAME = "db2-server-connector-task";
    private volatile Db2TaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Db2Connection dataConnection;
    private volatile Db2Connection metadataConnection;
    private volatile ErrorHandler errorHandler;
    private volatile Db2DatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator start(Configuration config) {
        Db2ConnectorConfig connectorConfig = new Db2ConnectorConfig(config);
        TopicSelector<TableId> topicSelector = Db2TopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create((Logger)LOGGER);
        config = ((Configuration.Builder)config.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).build();
        Configuration jdbcConfig = config.filter(x -> !x.startsWith("database.history.") && !x.equals(Db2ConnectorConfig.DATABASE_HISTORY.name())).subset("database.", true);
        this.dataConnection = new Db2Connection(jdbcConfig);
        this.metadataConnection = new Db2Connection(jdbcConfig);
        try {
            this.dataConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        this.schema = new Db2DatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector, this.dataConnection);
        this.schema.initializeStorage();
        OffsetContext previousOffset = this.getPreviousOffset(new Db2OffsetContext.Loader(connectorConfig));
        if (previousOffset != null) {
            this.schema.recover(previousOffset);
        }
        this.taskContext = new Db2TaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new ErrorHandler(Db2Connector.class, connectorConfig.getLogicalName(), this.queue);
        Db2EventMetadataProvider metadataProvider = new Db2EventMetadataProvider();
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster);
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffset, this.errorHandler, Db2Connector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new Db2ChangeEventSourceFactory(connectorConfig, this.dataConnection, this.metadataConnection, this.errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema), (ChangeEventSourceMetricsFactory)new DefaultChangeEventSourceMetricsFactory(), dispatcher, (DatabaseSchema)this.schema);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    protected OffsetContext getPreviousOffset(OffsetContext.Loader loader) {
        Map partition = loader.getPartition();
        Map previousOffset = (Map)this.context.offsetStorageReader().offsets(Collections.singleton(partition)).get(partition);
        if (previousOffset != null) {
            OffsetContext offsetContext = loader.load(previousOffset);
            LOGGER.info("Found previous offset {}", (Object)offsetContext);
            return offsetContext;
        }
        return null;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    public void doStop() {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return Db2ConnectorConfig.ALL_FIELDS;
    }
}

