/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Field;
import io.debezium.transforms.ScriptingTransformation;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;

@Incubating
public class ContentBasedRouter<R extends ConnectRecord<R>>
extends ScriptingTransformation<R> {
    public static final Field EXPRESSION = Field.create("topic.expression").withDisplayName("Topic name expression").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("An expression determining the new name of the topic the record should use. When null the record is delivered to the original topic.");

    @Override
    protected R doApply(R record) {
        String topicName = this.engine.eval((ConnectRecord<?>)record, String.class);
        return (R)(topicName == null ? record : record.newRecord(topicName, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp(), (Iterable)record.headers()));
    }

    @Override
    protected Field expressionField() {
        return EXPRESSION;
    }
}

