/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Lsn;
import io.debezium.relational.TableId;

public class ChangeTable {
    private static final String CDC_SCHEMA = "ASNCDC";
    private final String captureInstance;
    private final TableId sourceTableId;
    private final TableId changeTableId;
    private final Lsn startLsn;
    private Lsn stopLsn;
    private final int changeTableObjectId;

    public ChangeTable(TableId sourceTableId, String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this.sourceTableId = sourceTableId;
        this.captureInstance = captureInstance;
        this.changeTableObjectId = changeTableObjectId;
        this.startLsn = startLsn;
        this.stopLsn = stopLsn;
        this.changeTableId = sourceTableId != null ? new TableId(sourceTableId.catalog(), CDC_SCHEMA, captureInstance) : null;
    }

    public ChangeTable(String captureInstance, int changeTableObjectId, Lsn startLsn, Lsn stopLsn) {
        this(null, captureInstance, changeTableObjectId, startLsn, stopLsn);
    }

    public String getCaptureInstance() {
        return this.captureInstance;
    }

    public Lsn getStartLsn() {
        return this.startLsn;
    }

    public Lsn getStopLsn() {
        return this.stopLsn;
    }

    public void setStopLsn(Lsn stopLsn) {
        this.stopLsn = stopLsn;
    }

    public TableId getSourceTableId() {
        return this.sourceTableId;
    }

    public TableId getChangeTableId() {
        return this.changeTableId;
    }

    public int getChangeTableObjectId() {
        return this.changeTableObjectId;
    }

    public String toString() {
        return "Capture instance \"" + this.captureInstance + "\" [sourceTableId=" + this.sourceTableId + ", changeTableId=" + this.changeTableId + ", startLsn=" + this.startLsn + ", changeTableObjectId=" + this.changeTableObjectId + ", stopLsn=" + this.stopLsn + "]";
    }
}

