/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.Objects;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalChangeRecordEmitter
extends AbstractChangeRecordEmitter<TableSchema> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public RelationalChangeRecordEmitter(OffsetContext offsetContext, Clock clock) {
        super(offsetContext, clock);
    }

    @Override
    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver receiver) throws InterruptedException {
        TableSchema tableSchema = (TableSchema)schema;
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, tableSchema);
                break;
            }
            case READ: {
                this.emitReadRecord(receiver, tableSchema);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, tableSchema);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, tableSchema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
    }

    @Override
    protected void emitCreateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] newColumnValues = this.getNewColumnValues();
        Object newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().create(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        if (this.skipEmptyMessages() && (newColumnValues == null || newColumnValues.length == 0)) {
            this.logger.warn("no new values found for table '{}' from create message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        receiver.changeRecord(tableSchema, Envelope.Operation.CREATE, newKey, envelope, this.getOffset());
    }

    @Override
    protected void emitReadRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] newColumnValues = this.getNewColumnValues();
        Object newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().read(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(tableSchema, Envelope.Operation.READ, newKey, envelope, this.getOffset());
    }

    @Override
    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Object[] newColumnValues = this.getNewColumnValues();
        Object oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Object newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        if (this.skipEmptyMessages() && (newColumnValues == null || newColumnValues.length == 0)) {
            this.logger.warn("no new values found for table '{}' from update message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        if (oldKey == null || Objects.equals(oldKey, newKey)) {
            Struct envelope = tableSchema.getEnvelopeSchema().update(oldValue, newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
            receiver.changeRecord(tableSchema, Envelope.Operation.UPDATE, newKey, envelope, this.getOffset());
        } else {
            Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
            receiver.changeRecord(tableSchema, Envelope.Operation.DELETE, oldKey, envelope, this.getOffset());
            envelope = tableSchema.getEnvelopeSchema().create(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
            receiver.changeRecord(tableSchema, Envelope.Operation.CREATE, newKey, envelope, this.getOffset());
        }
    }

    @Override
    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Object oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        if (this.skipEmptyMessages() && (oldColumnValues == null || oldColumnValues.length == 0)) {
            this.logger.warn("no old values found for table '{}' from delete message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(tableSchema, Envelope.Operation.DELETE, oldKey, envelope, this.getOffset());
    }

    @Override
    protected abstract Envelope.Operation getOperation();

    protected abstract Object[] getOldColumnValues();

    protected abstract Object[] getNewColumnValues();

    protected boolean skipEmptyMessages() {
        return false;
    }
}

