/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.alloc;

import java.lang.reflect.Field;
import org.caffinitas.ohc.alloc.IAllocator;
import sun.misc.Unsafe;

public class UnsafeAllocator
implements IAllocator {
    static final Unsafe unsafe;

    @Override
    public long allocate(long size) {
        try {
            return unsafe.allocateMemory(size);
        }
        catch (OutOfMemoryError oom) {
            return 0L;
        }
    }

    @Override
    public void free(long peer) {
        unsafe.freeMemory(peer);
    }

    @Override
    public long getTotalAllocated() {
        return -1L;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

