/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.ArrayList;
import jflex.Interval;
import jflex.Macros;
import jflex.RegExp1;
import jflex.RegExp2;

public class RegExp {
    int type;

    public RegExp(int type) {
        this.type = type;
    }

    public String print(String tab) {
        return tab + this.toString();
    }

    public String toString() {
        return "type = " + this.type;
    }

    public boolean isCharClass(Macros macros) {
        switch (this.type) {
            case 50: 
            case 55: 
            case 56: 
            case 59: {
                return true;
            }
            case 44: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.isCharClass(macros) && binary.r2.isCharClass(macros);
            }
            case 52: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).isCharClass(macros);
            }
        }
        return false;
    }

    public int size(Macros macros) {
        switch (this.type) {
            case 44: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros) + 2;
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return binary.r1.size(macros) + binary.r2.size(macros);
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 43: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) + 2;
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros);
            }
            case 48: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros);
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return content.size(macros) * content.size(macros) * 3;
            }
            case 51: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return ((String)unary.content).length() + 1;
            }
            case 50: 
            case 59: {
                return 2;
            }
            case 55: 
            case 56: {
                return 2;
            }
            case 52: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).size(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }

    public static final String revString(String s) {
        char[] chars;
        StringBuffer b = new StringBuffer(s.length());
        for (int i = s.length(); i > 0; i -= chars.length) {
            int ch = s.codePointBefore(i);
            chars = Character.toChars(ch);
            b.append(chars);
        }
        return b.toString();
    }

    public final RegExp resolveTilde(Macros macros) {
        switch (this.type) {
            case 44: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(44, binary.r1.resolveTilde(macros), binary.r2.resolveTilde(macros));
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(57, binary.r1.resolveTilde(macros), binary.r2.resolveTilde(macros));
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.resolveTilde(macros));
            }
            case 43: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(43, content.resolveTilde(macros));
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.resolveTilde(macros));
            }
            case 48: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(48, content.resolveTilde(macros));
            }
            case 49: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = ((RegExp)unary.content).resolveTilde(macros);
                RegExp1 any_star = new RegExp1(42, this.anyChar());
                RegExp1 neg = new RegExp1(48, new RegExp2(57, any_star, new RegExp2(57, content, any_star)));
                return new RegExp2(57, neg, content);
            }
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
            case 52: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).resolveTilde(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }

    public RegExp anyChar() {
        ArrayList<Interval> list = new ArrayList<Interval>();
        list.add(new Interval(0, 0x10FFFF));
        return new RegExp1(55, list);
    }

    public final RegExp rev(Macros macros) {
        switch (this.type) {
            case 44: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(44, binary.r1.rev(macros), binary.r2.rev(macros));
            }
            case 57: {
                RegExp2 binary = (RegExp2)this;
                return new RegExp2(57, binary.r2.rev(macros), binary.r1.rev(macros));
            }
            case 42: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(42, content.rev(macros));
            }
            case 43: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(43, content.rev(macros));
            }
            case 45: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(45, content.rev(macros));
            }
            case 48: {
                RegExp1 unary = (RegExp1)this;
                RegExp content = (RegExp)unary.content;
                return new RegExp1(48, content.rev(macros));
            }
            case 49: {
                RegExp content = this.resolveTilde(macros);
                return content.rev(macros);
            }
            case 51: 
            case 58: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, RegExp.revString((String)unary.content));
            }
            case 50: 
            case 55: 
            case 56: 
            case 59: {
                RegExp1 unary = (RegExp1)this;
                return new RegExp1(unary.type, unary.content);
            }
            case 52: {
                RegExp1 unary = (RegExp1)this;
                return macros.getDefinition((String)unary.content).rev(macros);
            }
        }
        throw new Error("unknown regexp type " + this.type);
    }
}

