/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.signal;

import io.debezium.DebeziumException;
import io.debezium.document.Array;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.signal.Signal;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.SchemaChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaChanges<P extends Partition>
implements Signal.Action<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaChanges.class);
    public static final String NAME = "schema-changes";
    public static final String FIELD_CHANGES = "changes";
    public static final String FIELD_DATABASE = "database";
    public static final String FIELD_SCHEMA = "schema";
    private final JsonTableChangeSerializer serializer = new JsonTableChangeSerializer();
    private final boolean useCatalogBeforeSchema;
    private final EventDispatcher<P, TableId> dispatcher;

    public SchemaChanges(EventDispatcher<P, ? extends DataCollectionId> dispatcher, boolean useCatalogBeforeSchema) {
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.dispatcher = dispatcher;
    }

    @Override
    public boolean arrived(Signal.Payload<P> signalPayload) throws InterruptedException {
        Array changes = signalPayload.data.getArray(FIELD_CHANGES);
        String database = signalPayload.data.getString(FIELD_DATABASE);
        String schema = signalPayload.data.getString(FIELD_SCHEMA);
        if (changes == null || changes.isEmpty()) {
            LOGGER.warn("Table changes signal '{}' has arrived but the requested field '{}' is missing from data", signalPayload, (Object)FIELD_CHANGES);
            return false;
        }
        if (database == null || database.isEmpty()) {
            LOGGER.warn("Table changes signal '{}' has arrived but the requested field '{}' is missing from data", signalPayload, (Object)FIELD_DATABASE);
            return false;
        }
        for (TableChanges.TableChange tableChange : this.serializer.deserialize(changes, this.useCatalogBeforeSchema)) {
            if (this.dispatcher.getHistorizedSchema() != null) {
                LOGGER.info("Executing schema change for table '{}' requested by signal '{}'", (Object)tableChange.getId(), (Object)signalPayload.id);
                this.dispatcher.dispatchSchemaChangeEvent(tableChange.getId(), emitter -> emitter.schemaChangeEvent(new SchemaChangeEvent(signalPayload.partition.getSourcePartition(), signalPayload.offsetContext.getOffset(), signalPayload.source, database, schema, null, tableChange.getTable(), this.toSchemaChangeEventType(tableChange.getType()), false)));
                continue;
            }
            if (!(this.dispatcher.getSchema() instanceof RelationalDatabaseSchema)) continue;
            LOGGER.info("Executing schema change for table '{}' requested by signal '{}'", (Object)tableChange.getId(), (Object)signalPayload.id);
            RelationalDatabaseSchema databaseSchema = (RelationalDatabaseSchema)this.dispatcher.getSchema();
            if (tableChange.getType() != TableChanges.TableChangeType.CREATE && tableChange.getType() != TableChanges.TableChangeType.ALTER) continue;
            databaseSchema.refresh(tableChange.getTable());
        }
        return true;
    }

    private SchemaChangeEvent.SchemaChangeEventType toSchemaChangeEventType(TableChanges.TableChangeType type) {
        switch (type) {
            case CREATE: {
                return SchemaChangeEvent.SchemaChangeEventType.CREATE;
            }
            case ALTER: {
                return SchemaChangeEvent.SchemaChangeEventType.ALTER;
            }
            case DROP: {
                return SchemaChangeEvent.SchemaChangeEventType.DROP;
            }
        }
        throw new DebeziumException("Unknown table change event type " + (Object)((Object)type));
    }
}

