/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.CollectionTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TupleTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.UserDefinedTypeDeserializer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class MapTypeDeserializer
extends CollectionTypeDeserializer<MapType<?, ?>> {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Map<?, ?> deserializedMap = (Map<?, ?>)super.deserialize(abstractType, bb);
        deserializedMap = this.processKeyValueInDeserializedMap(abstractType, deserializedMap);
        return Values.convertToMap((Schema)this.getSchemaBuilder(abstractType).build(), deserializedMap);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        MapType mapType = (MapType)abstractType;
        AbstractType keysType = mapType.getKeysType();
        AbstractType valuesType = mapType.getValuesType();
        Schema keySchema = CassandraTypeDeserializer.getSchemaBuilder(keysType).build();
        Schema valuesSchema = CassandraTypeDeserializer.getSchemaBuilder(valuesType).build();
        return SchemaBuilder.map((Schema)keySchema, (Schema)valuesSchema).optional();
    }

    @Override
    public Object deserialize(MapType<?, ?> mapType, ComplexColumnData ccd) {
        List bbList = mapType.serializedValues(ccd.iterator());
        AbstractType keysType = mapType.getKeysType();
        AbstractType valuesType = mapType.getValuesType();
        HashMap<Object, Object> deserializedMap = new HashMap<Object, Object>();
        int i = 0;
        while (i < bbList.size()) {
            ByteBuffer kbb = (ByteBuffer)bbList.get(i++);
            ByteBuffer vbb = (ByteBuffer)bbList.get(i++);
            deserializedMap.put(CassandraTypeDeserializer.deserialize(keysType, kbb), CassandraTypeDeserializer.deserialize(valuesType, vbb));
        }
        return Values.convertToMap((Schema)this.getSchemaBuilder((AbstractType<?>)mapType).build(), deserializedMap);
    }

    private Map<?, ?> processKeyValueInDeserializedMap(AbstractType<?> abstractType, Map<?, ?> deserializedMap) {
        MapType mapType = (MapType)abstractType;
        AbstractType keysType = mapType.getKeysType();
        AbstractType valuesType = mapType.getValuesType();
        TypeDeserializer keysTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(keysType);
        TypeDeserializer valuesTypeDeserializer = CassandraTypeDeserializer.getTypeDeserializer(valuesType);
        HashMap resultedMap = new HashMap();
        for (Map.Entry<?, ?> entry : deserializedMap.entrySet()) {
            Object key = entry.getKey();
            if (keysTypeDeserializer instanceof LogicalTypeDeserializer) {
                key = ((LogicalTypeDeserializer)keysTypeDeserializer).formatDeserializedValue(keysType, key);
            } else if (keysTypeDeserializer instanceof UserDefinedTypeDeserializer || keysTypeDeserializer instanceof TupleTypeDeserializer) {
                key = keysTypeDeserializer.deserialize(keysType, (ByteBuffer)key);
            }
            Object value = entry.getValue();
            if (valuesTypeDeserializer instanceof LogicalTypeDeserializer) {
                value = ((LogicalTypeDeserializer)valuesTypeDeserializer).formatDeserializedValue(valuesType, value);
            } else if (valuesTypeDeserializer instanceof UserDefinedTypeDeserializer || valuesTypeDeserializer instanceof TupleTypeDeserializer) {
                value = valuesTypeDeserializer.deserialize(valuesType, (ByteBuffer)value);
            }
            resultedMap.put(key, value);
        }
        return resultedMap;
    }
}

