/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedId;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class DefaultPreparedStatement
implements PreparedStatement {
    final PreparedId preparedId;
    final String query;
    final String queryKeyspace;
    final Map<String, ByteBuffer> incomingPayload;
    final Cluster cluster;
    volatile ByteBuffer routingKey;
    volatile ConsistencyLevel consistency;
    volatile ConsistencyLevel serialConsistency;
    volatile boolean traceQuery;
    volatile RetryPolicy retryPolicy;
    volatile ImmutableMap<String, ByteBuffer> outgoingPayload;
    volatile Boolean idempotent;

    private DefaultPreparedStatement(PreparedId id, String query, String queryKeyspace, Map<String, ByteBuffer> incomingPayload, Cluster cluster) {
        this.preparedId = id;
        this.query = query;
        this.queryKeyspace = queryKeyspace;
        this.incomingPayload = incomingPayload;
        this.cluster = cluster;
    }

    static DefaultPreparedStatement fromMessage(Responses.Result.Prepared msg, Cluster cluster, String query, String queryKeyspace) {
        assert (msg.metadata.columns != null);
        ColumnDefinitions defs = msg.metadata.columns;
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        PreparedId.PreparedMetadata boundValuesMetadata = new PreparedId.PreparedMetadata(msg.statementId, defs);
        PreparedId.PreparedMetadata resultSetMetadata = new PreparedId.PreparedMetadata(msg.resultMetadataId, msg.resultMetadata.columns);
        int[] pkIndices = null;
        if (defs.size() > 0) {
            pkIndices = protocolVersion.compareTo(ProtocolVersion.V4) >= 0 ? msg.metadata.pkIndices : DefaultPreparedStatement.computePkIndices(cluster.getMetadata(), defs);
        }
        PreparedId preparedId = new PreparedId(boundValuesMetadata, resultSetMetadata, pkIndices, protocolVersion);
        return new DefaultPreparedStatement(preparedId, query, queryKeyspace, msg.getCustomPayload(), cluster);
    }

    private static int[] computePkIndices(Metadata clusterMetadata, ColumnDefinitions boundColumns) {
        TableMetadata tm;
        List<ColumnMetadata> partitionKeyColumns = null;
        int[] pkIndexes = null;
        KeyspaceMetadata km = clusterMetadata.getKeyspace(Metadata.quote(boundColumns.getKeyspace(0)));
        if (km != null && (tm = km.getTable(Metadata.quote(boundColumns.getTable(0)))) != null) {
            partitionKeyColumns = tm.getPartitionKey();
            pkIndexes = new int[partitionKeyColumns.size()];
            for (int i = 0; i < pkIndexes.length; ++i) {
                pkIndexes[i] = -1;
            }
        }
        for (int i = 0; i < boundColumns.size(); ++i) {
            DefaultPreparedStatement.maybeGetIndex(boundColumns.getName(i), i, partitionKeyColumns, pkIndexes);
        }
        return DefaultPreparedStatement.allSet(pkIndexes) ? pkIndexes : null;
    }

    private static void maybeGetIndex(String name, int j, List<ColumnMetadata> pkColumns, int[] pkIndexes) {
        if (pkColumns == null) {
            return;
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            if (!name.equals(pkColumns.get(i).getName())) continue;
            pkIndexes[i] = j;
            return;
        }
    }

    private static boolean allSet(int[] pkColumns) {
        if (pkColumns == null) {
            return false;
        }
        for (int i = 0; i < pkColumns.length; ++i) {
            if (pkColumns[i] >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public ColumnDefinitions getVariables() {
        return this.preparedId.boundValuesMetadata.variables;
    }

    @Override
    public BoundStatement bind(Object ... values) {
        BoundStatement bs = new BoundStatement(this);
        return bs.bind(values);
    }

    @Override
    public BoundStatement bind() {
        return new BoundStatement(this);
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public PreparedStatement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    @Override
    public PreparedStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        if (!serialConsistency.isSerial()) {
            throw new IllegalArgumentException();
        }
        this.serialConsistency = serialConsistency;
        return this;
    }

    @Override
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public String getQueryKeyspace() {
        return this.queryKeyspace;
    }

    @Override
    public PreparedStatement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    @Override
    public PreparedStatement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    @Override
    public boolean isTracing() {
        return this.traceQuery;
    }

    @Override
    public PreparedStatement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    @Override
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public PreparedId getPreparedId() {
        return this.preparedId;
    }

    @Override
    public Map<String, ByteBuffer> getIncomingPayload() {
        return this.incomingPayload;
    }

    @Override
    public Map<String, ByteBuffer> getOutgoingPayload() {
        return this.outgoingPayload;
    }

    @Override
    public PreparedStatement setOutgoingPayload(Map<String, ByteBuffer> payload) {
        this.outgoingPayload = payload == null ? null : ImmutableMap.copyOf(payload);
        return this;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.cluster.getConfiguration().getCodecRegistry();
    }

    @Override
    public PreparedStatement setIdempotent(Boolean idempotent) {
        this.idempotent = idempotent;
        return this;
    }

    @Override
    public Boolean isIdempotent() {
        return this.idempotent;
    }
}

