/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.MetricRegistry;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RemoteEndpointAwareNettySSLOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.annotations.VisibleForTesting;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.CassandraConnectorTask;
import io.debezium.connector.cassandra.network.SslContextFactory;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CassandraClient
implements AutoCloseable {
    private static final LoadBalancingPolicy DEFAULT_POLICY = new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build());
    private final Cluster cluster;
    private final Session session;

    public CassandraClient(CassandraConnectorConfig config) throws GeneralSecurityException, IOException {
        this(config, DEFAULT_POLICY);
    }

    @VisibleForTesting
    CassandraClient(CassandraConnectorConfig config, LoadBalancingPolicy lbPolicy) throws GeneralSecurityException, IOException {
        Cluster.Builder builder = Cluster.builder().addContactPoints(config.cassandraHosts()).withPort(config.cassandraPort()).withProtocolVersion(ProtocolVersion.V4).withLoadBalancingPolicy(lbPolicy).withoutJMXReporting();
        if (config.cassandraUsername() != null && config.cassandraPassword() != null) {
            builder.withCredentials(config.cassandraUsername(), config.cassandraPassword());
        }
        if (config.cassandraSslEnabled()) {
            SslContext sslContext = SslContextFactory.createSslContext(config.cassandraSslConfigPath());
            RemoteEndpointAwareNettySSLOptions sslOptions = new RemoteEndpointAwareNettySSLOptions(sslContext);
            builder.withSSL((SSLOptions)sslOptions);
        }
        this.cluster = builder.build();
        this.session = this.cluster.connect();
        this.registerClusterMetrics(this.cluster.getClusterName());
    }

    public List<TableMetadata> getCdcEnabledTableMetadataList() {
        return this.cluster.getMetadata().getKeyspaces().stream().map(KeyspaceMetadata::getTables).flatMap(Collection::stream).filter(tm -> tm.getOptions().isCDC()).collect(Collectors.toList());
    }

    public TableMetadata getCdcEnabledTableMetadata(String keyspace, String table) {
        TableMetadata tm = this.cluster.getMetadata().getKeyspace(keyspace).getTable(table);
        return tm.getOptions().isCDC() ? tm : null;
    }

    public Set<Host> getHosts() {
        return this.cluster.getMetadata().getAllHosts();
    }

    public String getClusterName() {
        return this.cluster.getMetadata().getClusterName();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isQueryable() {
        return !this.cluster.isClosed() && !this.session.isClosed();
    }

    public ResultSet execute(Statement statement) {
        return this.session.execute(statement);
    }

    public ResultSet execute(String query) {
        return this.session.execute(query);
    }

    public ResultSet execute(String query, Object ... values) {
        return this.session.execute(query, values);
    }

    public ResultSet execute(String query, Map<String, Object> values) {
        return this.session.execute(query, values);
    }

    public void shutdown() {
        if (!this.session.isClosed()) {
            this.session.close();
        }
        if (!this.cluster.isClosed()) {
            this.cluster.close();
        }
    }

    private void registerClusterMetrics(String prefix) {
        MetricRegistry clusterRegistry = this.cluster.getMetrics().getRegistry();
        clusterRegistry.getMetrics().forEach((key, value) -> CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register(MetricRegistry.name((String)prefix, (String[])new String[]{key}), value));
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

