/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer.filter;

import java.util.Locale;
import org.apache.cassandra.index.sasi.analyzer.filter.FilterPipelineTask;

public class BasicResultFilters {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    public static class NoOperation
    extends FilterPipelineTask<Object, Object> {
        @Override
        public Object process(Object input) throws Exception {
            return input;
        }
    }

    public static class UpperCase
    extends FilterPipelineTask<String, String> {
        private Locale locale;

        public UpperCase(Locale locale) {
            this.locale = locale;
        }

        public UpperCase() {
            this.locale = DEFAULT_LOCALE;
        }

        @Override
        public String process(String input) throws Exception {
            return input.toUpperCase(this.locale);
        }
    }

    public static class LowerCase
    extends FilterPipelineTask<String, String> {
        private Locale locale;

        public LowerCase(Locale locale) {
            this.locale = locale;
        }

        public LowerCase() {
            this.locale = DEFAULT_LOCALE;
        }

        @Override
        public String process(String input) throws Exception {
            return input.toLowerCase(this.locale);
        }
    }
}

