/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.compaction.SizeTieredCompactionStrategyOptions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeWindowCompactionStrategyOptions {
    private static final Logger logger = LoggerFactory.getLogger(TimeWindowCompactionStrategyOptions.class);
    protected static final TimeUnit DEFAULT_TIMESTAMP_RESOLUTION = TimeUnit.MICROSECONDS;
    protected static final TimeUnit DEFAULT_COMPACTION_WINDOW_UNIT = TimeUnit.DAYS;
    protected static final int DEFAULT_COMPACTION_WINDOW_SIZE = 1;
    protected static final int DEFAULT_EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS = 600;
    protected static final Boolean DEFAULT_UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION = false;
    protected static final String TIMESTAMP_RESOLUTION_KEY = "timestamp_resolution";
    protected static final String COMPACTION_WINDOW_UNIT_KEY = "compaction_window_unit";
    protected static final String COMPACTION_WINDOW_SIZE_KEY = "compaction_window_size";
    protected static final String EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY = "expired_sstable_check_frequency_seconds";
    protected static final String UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY = "unsafe_aggressive_sstable_expiration";
    static final String UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_PROPERTY = "cassandra.allow_unsafe_aggressive_sstable_expiration";
    protected final int sstableWindowSize;
    protected final TimeUnit sstableWindowUnit;
    protected final TimeUnit timestampResolution;
    protected final long expiredSSTableCheckFrequency;
    protected final boolean ignoreOverlaps;
    SizeTieredCompactionStrategyOptions stcsOptions;
    protected static final ImmutableList<TimeUnit> validTimestampTimeUnits = ImmutableList.of((Object)((Object)TimeUnit.SECONDS), (Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)TimeUnit.MICROSECONDS), (Object)((Object)TimeUnit.NANOSECONDS));
    protected static final ImmutableList<TimeUnit> validWindowTimeUnits = ImmutableList.of((Object)((Object)TimeUnit.MINUTES), (Object)((Object)TimeUnit.HOURS), (Object)((Object)TimeUnit.DAYS));

    public TimeWindowCompactionStrategyOptions(Map<String, String> options) {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        TimeUnit timeUnit = this.timestampResolution = optionValue == null ? DEFAULT_TIMESTAMP_RESOLUTION : TimeUnit.valueOf(optionValue);
        if (this.timestampResolution != DEFAULT_TIMESTAMP_RESOLUTION) {
            logger.warn("Using a non-default timestamp_resolution {} - are you really doing inserts with USING TIMESTAMP <non_microsecond_timestamp> (or driver equivalent)?", (Object)this.timestampResolution.toString());
        }
        this.sstableWindowUnit = (optionValue = options.get(COMPACTION_WINDOW_UNIT_KEY)) == null ? DEFAULT_COMPACTION_WINDOW_UNIT : TimeUnit.valueOf(optionValue);
        optionValue = options.get(COMPACTION_WINDOW_SIZE_KEY);
        this.sstableWindowSize = optionValue == null ? 1 : Integer.parseInt(optionValue);
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(optionValue == null ? 600L : Long.parseLong(optionValue), TimeUnit.SECONDS);
        optionValue = options.get(UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY);
        this.ignoreOverlaps = optionValue == null ? DEFAULT_UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION : Boolean.getBoolean(UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_PROPERTY) && Boolean.parseBoolean(optionValue);
        this.stcsOptions = new SizeTieredCompactionStrategyOptions(options);
    }

    public TimeWindowCompactionStrategyOptions() {
        this.sstableWindowUnit = DEFAULT_COMPACTION_WINDOW_UNIT;
        this.timestampResolution = DEFAULT_TIMESTAMP_RESOLUTION;
        this.sstableWindowSize = 1;
        this.expiredSSTableCheckFrequency = TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS);
        this.ignoreOverlaps = DEFAULT_UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION;
        this.stcsOptions = new SizeTieredCompactionStrategyOptions();
    }

    public static Map<String, String> validateOptions(Map<String, String> options, Map<String, String> uncheckedOptions) throws ConfigurationException {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        try {
            if (optionValue != null && !validTimestampTimeUnits.contains((Object)TimeUnit.valueOf(optionValue))) {
                throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, TIMESTAMP_RESOLUTION_KEY));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, TIMESTAMP_RESOLUTION_KEY));
        }
        optionValue = options.get(COMPACTION_WINDOW_UNIT_KEY);
        try {
            if (optionValue != null && !validWindowTimeUnits.contains((Object)TimeUnit.valueOf(optionValue))) {
                throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, COMPACTION_WINDOW_UNIT_KEY));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("%s is not valid for %s", optionValue, COMPACTION_WINDOW_UNIT_KEY), e);
        }
        optionValue = options.get(COMPACTION_WINDOW_SIZE_KEY);
        try {
            int sstableWindowSize;
            int n = sstableWindowSize = optionValue == null ? 1 : Integer.parseInt(optionValue);
            if (sstableWindowSize < 1) {
                throw new ConfigurationException(String.format("%d must be greater than 1 for %s", sstableWindowSize, COMPACTION_WINDOW_SIZE_KEY));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, COMPACTION_WINDOW_SIZE_KEY), e);
        }
        optionValue = options.get(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        try {
            long expiredCheckFrequency;
            long l = expiredCheckFrequency = optionValue == null ? 600L : Long.parseLong(optionValue);
            if (expiredCheckFrequency < 0L) {
                throw new ConfigurationException(String.format("%s must not be negative, but was %d", EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY, expiredCheckFrequency));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY), e);
        }
        optionValue = options.get(UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY);
        if (optionValue != null) {
            if (!optionValue.equalsIgnoreCase("true") && !optionValue.equalsIgnoreCase("false")) {
                throw new ConfigurationException(String.format("%s is not 'true' or 'false' (%s)", UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY, optionValue));
            }
            if (optionValue.equalsIgnoreCase("true") && !Boolean.getBoolean(UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_PROPERTY)) {
                throw new ConfigurationException(String.format("%s is requested but not allowed, restart cassandra with -D%s=true to allow it", UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY, UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_PROPERTY));
            }
        }
        uncheckedOptions.remove(COMPACTION_WINDOW_SIZE_KEY);
        uncheckedOptions.remove(COMPACTION_WINDOW_UNIT_KEY);
        uncheckedOptions.remove(TIMESTAMP_RESOLUTION_KEY);
        uncheckedOptions.remove(EXPIRED_SSTABLE_CHECK_FREQUENCY_SECONDS_KEY);
        uncheckedOptions.remove(UNSAFE_AGGRESSIVE_SSTABLE_EXPIRATION_KEY);
        uncheckedOptions = SizeTieredCompactionStrategyOptions.validateOptions(options, uncheckedOptions);
        return uncheckedOptions;
    }
}

