/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import java.util.Arrays;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(DoubleLookupContainer c) {
        final DoubleLookupContainer c2 = c;
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(DoubleLookupContainer c) {
        final DoubleLookupContainer c2 = c;
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public double[] toArray() {
        int size = this.size();
        double[] array = new double[size];
        int i = 0;
        for (DoubleCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

