/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.AbstractProcessor;
import io.debezium.connector.cassandra.CassandraConnectorTask;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class CassandraConnectorTaskTest {
    @Test(timeout=60000L)
    public void testProcessorGroup() throws Exception {
        CassandraConnectorTask.ProcessorGroup processorGroup = new CassandraConnectorTask.ProcessorGroup();
        final AtomicInteger running = new AtomicInteger(0);
        final AtomicInteger iteration = new AtomicInteger(0);
        AbstractProcessor processor1 = new AbstractProcessor("processor1", Duration.ofMillis(100L)){

            public void initialize() {
                running.incrementAndGet();
            }

            public void destroy() {
                running.decrementAndGet();
            }

            public void process() {
                iteration.incrementAndGet();
            }
        };
        AbstractProcessor processor2 = new AbstractProcessor("processor2", Duration.ofMillis(100L)){

            public void initialize() {
                running.incrementAndGet();
            }

            public void destroy() {
                running.decrementAndGet();
            }

            public void process() {
                iteration.incrementAndGet();
            }
        };
        processorGroup.addProcessor(processor1);
        processorGroup.addProcessor(processor2);
        processorGroup.start();
        while (!processor1.isRunning() || !processor2.isRunning()) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)processorGroup.isRunning());
        Assert.assertEquals((long)2L, (long)running.get());
        Assert.assertTrue((iteration.get() >= 1 ? 1 : 0) != 0);
        processorGroup.terminate();
        Assert.assertFalse((boolean)processor1.isRunning());
        Assert.assertFalse((boolean)processor2.isRunning());
        Assert.assertEquals((long)0L, (long)running.get());
    }
}

