/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaProtobufSerializer<T extends Message>
extends AbstractKafkaProtobufSerializer<T>
implements Serializer<T> {
    private static int DEFAULT_CACHE_CAPACITY = 1000;
    private boolean isKey;
    private Cache<Descriptors.Descriptor, ProtobufSchema> schemaCache;

    public KafkaProtobufSerializer() {
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(DEFAULT_CACHE_CAPACITY));
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, DEFAULT_CACHE_CAPACITY);
    }

    public KafkaProtobufSerializer(SchemaRegistryClient client, Map<String, ?> props, int cacheCapacity) {
        this.schemaRegistry = client;
        this.configure(this.serializerConfig(props));
        this.schemaCache = new SynchronizedCache((Cache)new LRUCache(cacheCapacity));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaProtobufSerializerConfig(configs));
    }

    public byte[] serialize(String topic, T record) {
        if (record == null) {
            return null;
        }
        ProtobufSchema schema = (ProtobufSchema)this.schemaCache.get((Object)record.getDescriptorForType());
        if (schema == null) {
            schema = ProtobufSchemaUtils.getSchema(record);
            try {
                schema = KafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.autoRegisterSchema, this.useLatestVersion, this.latestCompatStrict, (Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema>)this.latestVersions, this.referenceSubjectNameStrategy, topic, this.isKey, schema);
            }
            catch (RestClientException | IOException e) {
                throw new SerializationException("Error serializing Protobuf message", e);
            }
            this.schemaCache.put((Object)record.getDescriptorForType(), (Object)schema);
        }
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, (ParsedSchema)schema), topic, this.isKey, record, schema);
    }

    public void close() {
    }
}

