/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Context {
    private final Set<Difference.Type> compatibleChanges;
    private final Set<MessageElement> schemas;
    private final Map<String, TypeElementInfo> originalTypes;
    private final Map<String, TypeElementInfo> updateTypes;
    private String originalPackageName;
    private String updatePackageName;
    private final Deque<String> fullPath;
    private final Deque<String> fullName;
    private final List<Difference> diffs;

    public Context(Set<Difference.Type> compatibleChanges) {
        this.compatibleChanges = compatibleChanges;
        this.schemas = Collections.newSetFromMap(new IdentityHashMap());
        this.originalTypes = new HashMap<String, TypeElementInfo>();
        this.updateTypes = new HashMap<String, TypeElementInfo>();
        this.fullPath = new ArrayDeque<String>();
        this.fullName = new ArrayDeque<String>();
        this.diffs = new ArrayList<Difference>();
    }

    public Context getSubcontext() {
        Context ctx = new Context(this.compatibleChanges);
        ctx.schemas.addAll(this.schemas);
        ctx.originalTypes.putAll(this.originalTypes);
        ctx.updateTypes.putAll(this.updateTypes);
        ctx.originalPackageName = this.originalPackageName;
        ctx.updatePackageName = this.updatePackageName;
        ctx.fullPath.addAll(this.fullPath);
        ctx.fullName.addAll(this.fullName);
        return ctx;
    }

    public SchemaScope enterSchema(MessageElement schema) {
        return !this.schemas.contains(schema) ? new SchemaScope(schema) : null;
    }

    public void addType(String name, String packageName, SchemaReference ref, TypeElement type, boolean isMap, FieldElement key, FieldElement value, boolean isOriginal) {
        if (isOriginal) {
            this.originalTypes.put(name, new TypeElementInfo(packageName, ref, type, isMap, key, value));
        } else {
            this.updateTypes.put(name, new TypeElementInfo(packageName, ref, type, isMap, key, value));
        }
    }

    public TypeElementInfo getType(String name, boolean isOriginal) {
        String fullName = this.resolve(name, isOriginal);
        return this.getTypeForFullName(fullName, isOriginal);
    }

    public void setPackageName(String packageName, boolean isOriginal) {
        if (isOriginal) {
            this.originalPackageName = packageName;
        } else {
            this.updatePackageName = packageName;
        }
    }

    public void setFullName(String name) {
        List<String> parts = Arrays.asList(name.split("\\."));
        this.fullPath.clear();
        this.fullName.clear();
        this.fullPath.addAll(parts);
        this.fullName.addAll(parts);
    }

    public PathScope enterPath(String path) {
        return new PathScope(path);
    }

    public NamedScope enterName(String name) {
        return new NamedScope(name);
    }

    public String resolve(String name, boolean isOriginal) {
        if (name.startsWith(".")) {
            String n = name.substring(1);
            TypeElementInfo type = this.getTypeForFullName(n, isOriginal);
            if (type != null) {
                return n;
            }
        } else {
            ArrayDeque<String> prefix = new ArrayDeque<String>(this.fullName);
            if (isOriginal) {
                if (!this.originalPackageName.isEmpty()) {
                    prefix.addFirst(this.originalPackageName);
                }
            } else if (!this.updatePackageName.isEmpty()) {
                prefix.addFirst(this.updatePackageName);
            }
            while (!prefix.isEmpty()) {
                String n = String.join((CharSequence)".", prefix) + "." + name;
                TypeElementInfo type = this.getTypeForFullName(n, isOriginal);
                if (type != null) {
                    return n;
                }
                prefix.removeLast();
            }
            TypeElementInfo type = this.getTypeForFullName(name, isOriginal);
            if (type != null) {
                return name;
            }
        }
        return null;
    }

    private TypeElementInfo getTypeForFullName(String fullName, boolean isOriginal) {
        if (isOriginal) {
            return this.originalTypes.get(fullName);
        }
        return this.updateTypes.get(fullName);
    }

    public boolean isCompatible() {
        boolean notCompatible = this.getDifferences().stream().map(Difference::getType).anyMatch(t -> !this.compatibleChanges.contains(t));
        return !notCompatible;
    }

    public List<Difference> getDifferences() {
        return this.diffs;
    }

    public void addDifference(Difference.Type type) {
        this.diffs.add(new Difference(type, Context.fullPathString(this.fullPath)));
    }

    public void addDifference(String attribute, Difference.Type type) {
        this.fullPath.addLast(attribute);
        this.addDifference(type);
        this.fullPath.removeLast();
    }

    public void addDifferences(List<Difference> differences) {
        this.diffs.addAll(differences);
    }

    private static String fullPathString(Deque<String> fullPath) {
        return "#/" + String.join((CharSequence)"/", fullPath);
    }

    static class TypeElementInfo {
        private final String packageName;
        private final SchemaReference ref;
        private final TypeElement type;
        private final boolean isMap;
        private final FieldElement key;
        private final FieldElement value;

        public TypeElementInfo(String packageName, SchemaReference ref, TypeElement type, boolean isMap, FieldElement key, FieldElement value) {
            this.packageName = packageName;
            this.ref = ref;
            this.type = type;
            this.isMap = isMap;
            this.key = key;
            this.value = value;
        }

        public String packageName() {
            return this.packageName;
        }

        public SchemaReference reference() {
            return this.ref;
        }

        public TypeElement type() {
            return this.type;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public FieldElement key() {
            return this.key;
        }

        public FieldElement value() {
            return this.value;
        }

        public ProtoType getMapType() {
            return this.isMap ? ProtoType.get((String)("map<" + this.key.getType() + ", " + this.value.getType() + ">")) : null;
        }
    }

    public class NamedScope
    extends PathScope {
        public NamedScope(String name) {
            super(name);
            Context.this.fullName.addLast(name);
        }

        @Override
        public void close() {
            Context.this.fullName.removeLast();
            super.close();
        }
    }

    public class PathScope
    implements AutoCloseable {
        public PathScope(String path) {
            Context.this.fullPath.addLast(path);
        }

        @Override
        public void close() {
            Context.this.fullPath.removeLast();
        }
    }

    public class SchemaScope
    implements AutoCloseable {
        private final MessageElement schema;

        public SchemaScope(MessageElement schema) {
            this.schema = schema;
            Context.this.schemas.add(schema);
        }

        @Override
        public void close() {
            Context.this.schemas.remove(this.schema);
        }
    }
}

