/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectoryWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDirectoryWatcher.class);
    private final WatchService watchService;
    private final Duration pollInterval;
    private final Path directory;
    private final Set<WatchEvent.Kind> kinds;

    public AbstractDirectoryWatcher(Path directory, Duration pollInterval, Set<WatchEvent.Kind> kinds) throws IOException {
        this(FileSystems.getDefault().newWatchService(), directory, pollInterval, kinds);
    }

    AbstractDirectoryWatcher(WatchService watchService, Path directory, Duration pollInterval, Set<WatchEvent.Kind> kinds) throws IOException {
        this.watchService = watchService;
        this.pollInterval = pollInterval;
        this.directory = directory;
        this.kinds = kinds;
        directory.register(watchService, kinds.toArray(new WatchEvent.Kind[kinds.size()]));
    }

    public void poll() throws InterruptedException, IOException {
        LOGGER.info("Polling commitLog files from {} ...", (Object)this.directory);
        WatchKey key = this.watchService.poll(this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
        if (key != null) {
            LOGGER.info("Detected new commitLog files in {}.", (Object)this.directory);
            for (WatchEvent<?> event : key.pollEvents()) {
                Path relativePath = (Path)event.context();
                Path absolutePath = this.directory.resolve(relativePath);
                if (!this.kinds.contains(event.kind())) continue;
                this.handleEvent(event, absolutePath);
            }
            key.reset();
        } else {
            LOGGER.info("No commitLogFile is detected in {}.", (Object)this.directory);
        }
    }

    abstract void handleEvent(WatchEvent<?> var1, Path var2) throws IOException;
}

