/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.cassandra.CellData;
import io.debezium.connector.cassandra.KafkaRecord;
import io.debezium.connector.cassandra.KeyValueSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class RowData
implements KafkaRecord {
    private final Map<String, CellData> cellMap = new LinkedHashMap<String, CellData>();

    public void addCell(CellData cellData) {
        this.cellMap.put(cellData.name, cellData);
    }

    public void removeCell(String columnName) {
        if (this.hasCell(columnName)) {
            this.cellMap.remove(columnName);
        }
    }

    public boolean hasCell(String columnName) {
        return this.cellMap.containsKey(columnName);
    }

    @Override
    public Struct record(Schema schema) {
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            Schema cellSchema = KeyValueSchema.getFieldSchema(field.name(), schema);
            CellData cellData = this.cellMap.get(field.name());
            if (cellData == null) continue;
            struct.put(field.name(), (Object)cellData.record(cellSchema));
        }
        return struct;
    }

    public RowData copy() {
        RowData copy = new RowData();
        for (CellData cellData : this.cellMap.values()) {
            copy.addCell(cellData);
        }
        return copy;
    }

    static Schema rowSchema(TableMetadata tm) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("after");
        for (ColumnMetadata cm : tm.getColumns()) {
            Schema optionalCellSchema = CellData.cellSchema(cm, true);
            if (optionalCellSchema == null) continue;
            schemaBuilder.field(cm.getName(), optionalCellSchema);
        }
        return schemaBuilder.build();
    }

    List<CellData> getPrimary() {
        return this.cellMap.values().stream().filter(CellData::isPrimary).collect(Collectors.toList());
    }

    public String toString() {
        return this.cellMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowData rowData = (RowData)o;
        return Objects.equals(this.cellMap, rowData.cellMap);
    }

    public int hashCode() {
        return Objects.hash(this.cellMap);
    }
}

