/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.header.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.utils.Utils;

public class RecordHeader
implements Header {
    private ByteBuffer keyBuffer;
    private String key;
    private ByteBuffer valueBuffer;
    private byte[] value;

    public RecordHeader(String key, byte[] value) {
        Objects.requireNonNull(key, "Null header keys are not permitted");
        this.key = key;
        this.value = value;
    }

    public RecordHeader(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        this.keyBuffer = Objects.requireNonNull(keyBuffer, "Null header keys are not permitted");
        this.valueBuffer = valueBuffer;
    }

    @Override
    public String key() {
        if (this.key == null) {
            this.key = Utils.utf8(this.keyBuffer, this.keyBuffer.remaining());
            this.keyBuffer = null;
        }
        return this.key;
    }

    @Override
    public byte[] value() {
        if (this.value == null && this.valueBuffer != null) {
            this.value = Utils.toArray(this.valueBuffer);
            this.valueBuffer = null;
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordHeader header = (RecordHeader)o;
        return Objects.equals(this.key(), header.key()) && Arrays.equals(this.value(), header.value());
    }

    public int hashCode() {
        int result = this.key() != null ? this.key().hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.value());
        return result;
    }

    public String toString() {
        return "RecordHeader(key = " + this.key() + ", value = " + Arrays.toString(this.value()) + ")";
    }
}

