/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.FileOffsetWriter;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.common.CdcSourceTaskContext;
import java.util.Collections;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;

public class CassandraConnectorContext
extends CdcSourceTaskContext {
    private final CassandraConnectorConfig config;
    private final CassandraClient cassandraClient;
    private final ChangeEventQueue<Event> queue;
    private final SchemaHolder schemaHolder;
    private final OffsetWriter offsetWriter;

    public CassandraConnectorContext(CassandraConnectorConfig config) throws Exception {
        super(config.getContextName(), config.getLogicalName(), Collections::emptySet);
        this.config = config;
        try {
            this.loadDdlFromDisk(this.config.cassandraConfig());
            this.cassandraClient = new CassandraClient(this.config);
            this.queue = new ChangeEventQueue.Builder().pollInterval(this.config.pollInterval()).maxBatchSize(this.config.maxBatchSize()).maxQueueSize(this.config.maxQueueSize()).loggingContextSupplier(() -> this.configureLoggingContext(this.config.getContextName())).build();
            this.schemaHolder = new SchemaHolder(this.cassandraClient, this.config.kafkaTopicPrefix(), this.config.getSourceInfoStructMaker());
            this.offsetWriter = new FileOffsetWriter(this.config.offsetBackingStoreDir());
        }
        catch (Exception e) {
            this.cleanUp();
            throw e;
        }
    }

    public void loadDdlFromDisk(String yamlConfig) {
        System.setProperty("cassandra.config", "file:///" + yamlConfig);
        if (!DatabaseDescriptor.isDaemonInitialized() && !DatabaseDescriptor.isToolInitialized()) {
            DatabaseDescriptor.toolInitialization();
            Schema.instance.loadFromDisk(false);
        }
    }

    public void cleanUp() {
        if (this.cassandraClient != null) {
            this.cassandraClient.close();
        }
        if (this.offsetWriter != null) {
            this.offsetWriter.close();
        }
    }

    public CassandraConnectorConfig getCassandraConnectorConfig() {
        return this.config;
    }

    public CassandraClient getCassandraClient() {
        return this.cassandraClient;
    }

    public ChangeEventQueue<Event> getQueue() {
        return this.queue;
    }

    public OffsetWriter getOffsetWriter() {
        return this.offsetWriter;
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }
}

